/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger;

import java.util.Set;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.data.SimulationTimeReached;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterObjectWrapper;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.ComparatorResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.TriggerChecker;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.spd.triggers.BaseTrigger;
import org.palladiosimulator.spd.triggers.SimpleFireOnValue;
import org.palladiosimulator.spd.triggers.expectations.ExpectedTime;
import org.palladiosimulator.spd.triggers.stimuli.SimulationTime;

public final class SimulationTimeChecker
extends TriggerChecker<SimulationTime> {
    public SimulationTimeChecker(SimpleFireOnValue trigger) {
        super((BaseTrigger)trigger, SimulationTime.class, Set.of(ExpectedTime.class));
    }

    @Override
    public FilterResult doProcess(FilterObjectWrapper objectWrapper) {
        DESEvent event = objectWrapper.getEventToFilter();
        if (!(event instanceof SimulationTimeReached)) {
            return FilterResult.disregard("Expected simulation time reached event, but received" + event.getClass().getSimpleName());
        }
        SimulationTimeReached simulationTimeReached = (SimulationTimeReached)event;
        ComparatorResult comparatorResult = this.compareToTrigger(simulationTimeReached.time());
        if (comparatorResult == ComparatorResult.IN_ACCORDANCE) {
            return FilterResult.success(event);
        }
        return FilterResult.disregard(String.format("Simulationtime of %f is not [%s] expectedValue. [[%s]]", simulationTimeReached.time(), ((SimpleFireOnValue)this.trigger).getRelationalOperator().toString(), comparatorResult.toString()));
    }
}

