/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.SeffBehaviorWrapper;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.SingleBehaviorContextHolder;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;

public final class LoopBehaviorContextHolder
extends SingleBehaviorContextHolder {
    private static final Logger LOGGER = Logger.getLogger(LoopBehaviorContextHolder.class);
    private final int maximalLoopCounter;
    private int progression = 1;

    public LoopBehaviorContextHolder(ResourceDemandingBehaviour behavior, AbstractAction successor, SeffBehaviorWrapper parent, int maximalLoopCounter) {
        super(behavior, Optional.of(successor), Optional.of(parent));
        Preconditions.checkArgument((maximalLoopCounter >= 0 ? 1 : 0) != 0, (Object)"The loop counter must be >= 0");
        this.maximalLoopCounter = maximalLoopCounter;
    }

    @Override
    public boolean hasFinished() {
        LOGGER.debug((Object)("Progression: " + this.progression + " -- Maximum: " + this.maximalLoopCounter));
        return super.hasFinished() && this.progression == this.maximalLoopCounter;
    }

    public AbstractAction getNextAction() {
        LOGGER.info((Object)("Retrieve next action in loop -- progression: " + this.progression));
        if (this.getCurrentProcessedBehavior().hasFinished() && this.progression < this.maximalLoopCounter) {
            ++this.progression;
            this.getCurrentProcessedBehavior().repeatScenario();
        }
        return (AbstractAction)super.getNextAction();
    }
}

