/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.SEFFInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.User;
import org.palladiosimulator.analyzer.slingshot.common.utils.Logic;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;

public final class ResourceDemandRequest {
    private final AssemblyContext assemblyContext;
    private final SEFFInterpretationContext seffInterpretationContext;
    private final ParametricResourceDemand parametricResourceDemand;
    private final ResourceType resourceType;
    private final Optional<PassiveResource> passiveResource;

    private ResourceDemandRequest(Builder builder) {
        Preconditions.checkArgument((boolean)Logic.implies((builder.resourceType == ResourceType.PASSIVE ? 1 : 0) != 0, (boolean)builder.passiveResource.isPresent()), (Object)"The passive resource must be supplied in this request in order for it to work.(ResourceDemandRequest is specified as a ResourceType.PASSIVE, but no passive resource was supplied)");
        this.assemblyContext = builder.assemblyContext;
        this.seffInterpretationContext = builder.seffInterpretationContext;
        this.parametricResourceDemand = builder.parametricResourceDemand;
        this.resourceType = builder.resourceType;
        this.passiveResource = builder.passiveResource;
    }

    public AssemblyContext getAssemblyContext() {
        return this.assemblyContext;
    }

    public SEFFInterpretationContext getSeffInterpretationContext() {
        return this.seffInterpretationContext;
    }

    public ParametricResourceDemand getParametricResourceDemand() {
        return this.parametricResourceDemand;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public User getUser() {
        return this.seffInterpretationContext.getRequestProcessingContext().getUser();
    }

    public Optional<PassiveResource> getPassiveResource() {
        return this.passiveResource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AssemblyContext assemblyContext;
        private SEFFInterpretationContext seffInterpretationContext;
        private ParametricResourceDemand parametricResourceDemand;
        private ResourceType resourceType = ResourceType.ACTIVE;
        private Optional<PassiveResource> passiveResource = Optional.empty();

        private Builder() {
        }

        public Builder withAssemblyContext(AssemblyContext assemblyContext) {
            this.assemblyContext = Builder.builderNonNull(assemblyContext);
            return this;
        }

        public Builder withSeffInterpretationContext(SEFFInterpretationContext seffInterpretationContext) {
            this.seffInterpretationContext = Builder.builderNonNull(seffInterpretationContext);
            return this;
        }

        public Builder withParametricResourceDemand(ParametricResourceDemand parametricResourceDemand) {
            this.parametricResourceDemand = Builder.builderNonNull(parametricResourceDemand);
            return this;
        }

        public Builder withResourceType(ResourceType resourceType) {
            this.resourceType = Builder.builderNonNull(resourceType);
            return this;
        }

        public Builder withPassiveResource(PassiveResource passiveResource) {
            this.passiveResource = passiveResource == null ? Optional.empty() : Optional.of(passiveResource);
            return this;
        }

        public Builder withPassiveResource(Optional<PassiveResource> passiveResource) {
            this.passiveResource = Builder.builderNonNull(passiveResource);
            return this;
        }

        private static <T> T builderNonNull(T reference) {
            return (T)Preconditions.checkNotNull(reference, (Object)"The builder does not allow null values.");
        }

        public ResourceDemandRequest build() {
            return new ResourceDemandRequest(this);
        }
    }

    public static enum ResourceType {
        ACTIVE,
        PASSIVE;

    }
}

