/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff;

import com.google.common.base.Preconditions;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Optional;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.CallOverWireRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.SeffBehaviorContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.user.RequestProcessingContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;

public final class SEFFInterpretationContext {
    private final SeffBehaviorContextHolder behaviorContext;
    private final RequestProcessingContext requestProcessingContext;
    private final AssemblyContext assemblyContext;
    private final Optional<SEFFInterpretationContext> calledFrom;
    private final Optional<CallOverWireRequest> callOverWireRequest;
    private final Optional<SEFFInterpretationContext> parent;
    private final SimulatedStackframe<Object> resultStackframe;

    private SEFFInterpretationContext(Builder builder) {
        assert (builder.callOverWireRequest == null || builder.callOverWireRequest != null && builder.calledFrom.isPresent()) : String.format("Missing caller in %s", this.getClass().getSimpleName());
        this.calledFrom = builder.calledFrom;
        this.behaviorContext = builder.behaviorContext;
        this.requestProcessingContext = builder.requestProcessingContext;
        this.assemblyContext = builder.assemblyContext;
        this.callOverWireRequest = Optional.ofNullable(builder.callOverWireRequest);
        this.parent = Optional.ofNullable(builder.parent);
        this.resultStackframe = builder.resultStackframe;
    }

    public SeffBehaviorContextHolder getBehaviorContext() {
        return this.behaviorContext;
    }

    public RequestProcessingContext getRequestProcessingContext() {
        return this.requestProcessingContext;
    }

    public AssemblyContext getAssemblyContext() {
        return this.assemblyContext;
    }

    public Optional<SEFFInterpretationContext> getCaller() {
        return this.calledFrom;
    }

    public Optional<CallOverWireRequest> getCallOverWireRequest() {
        return this.callOverWireRequest;
    }

    public SimulatedStackframe<Object> getCurrentResultStackframe() {
        if (this.resultStackframe != null) {
            return this.resultStackframe;
        }
        return this.parent.map(pr -> pr.getCurrentResultStackframe()).orElseGet(() -> this.requestProcessingContext.getUser().getStack().currentStackFrame());
    }

    public Optional<SEFFInterpretationContext> getParent() {
        return this.parent;
    }

    public Builder createChildContext() {
        return SEFFInterpretationContext.builder().withRequestProcessingContext(this.requestProcessingContext).withParent(this);
    }

    public Builder createChildContextPrefilled() {
        return this.update().withParent(this).withResultStackframe(null);
    }

    public Builder update() {
        return SEFFInterpretationContext.builder().withBehaviorContext(this.behaviorContext).withAssemblyContext(this.assemblyContext).withRequestProcessingContext(this.requestProcessingContext).withCaller(this.calledFrom).withParent(this.parent.orElse(null)).withCallOverWireRequest(this.callOverWireRequest.orElse(null)).withResultStackframe(this.getCurrentResultStackframe());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SeffBehaviorContextHolder behaviorContext;
        private RequestProcessingContext requestProcessingContext;
        private AssemblyContext assemblyContext;
        private Optional<SEFFInterpretationContext> calledFrom = Optional.empty();
        private CallOverWireRequest callOverWireRequest;
        private SEFFInterpretationContext parent;
        private SimulatedStackframe<Object> resultStackframe;

        private Builder() {
        }

        public Builder withParent(SEFFInterpretationContext parent) {
            this.parent = parent;
            return this;
        }

        public Builder withCallOverWireRequest(CallOverWireRequest callOverWireRequest) {
            assert (callOverWireRequest == null || callOverWireRequest.getReplyTo().isEmpty());
            this.callOverWireRequest = callOverWireRequest;
            return this;
        }

        public Builder withBehaviorContext(SeffBehaviorContextHolder behaviorContext) {
            this.behaviorContext = Builder.builderNonNull(behaviorContext);
            return this;
        }

        public Builder withRequestProcessingContext(RequestProcessingContext requestProcessingContext) {
            this.requestProcessingContext = Builder.builderNonNull(requestProcessingContext);
            return this;
        }

        public Builder withAssemblyContext(AssemblyContext assemblyContext) {
            this.assemblyContext = Builder.builderNonNull(assemblyContext);
            return this;
        }

        public Builder withCaller(Optional<SEFFInterpretationContext> caller) {
            this.calledFrom = Builder.builderNonNull(caller);
            return this;
        }

        public Builder withResultStackframe(SimulatedStackframe<Object> stackFrame) {
            this.resultStackframe = stackFrame;
            return this;
        }

        public SEFFInterpretationContext build() {
            return new SEFFInterpretationContext(this);
        }

        private static <T> T builderNonNull(T reference) {
            return (T)Preconditions.checkNotNull(reference, (Object)"Builder does not allow null-references.");
        }
    }
}

