/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.SeffBehaviorContextHolder;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;

public final class SeffBehaviorWrapper
implements Iterator<AbstractAction> {
    private final ResourceDemandingBehaviour behavior;
    private final SeffBehaviorContextHolder context;
    private AbstractAction currentAction;
    private boolean finished;

    public SeffBehaviorWrapper(ResourceDemandingBehaviour behavior, SeffBehaviorContextHolder context) {
        this.behavior = behavior;
        this.context = context;
        this.setCurrentActionToStart();
    }

    public ResourceDemandingBehaviour getBehavior() {
        return this.behavior;
    }

    public AbstractAction getCurrentAction() {
        return this.currentAction;
    }

    public SeffBehaviorContextHolder getContext() {
        return this.context;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public void repeatScenario() {
        this.setCurrentActionToStart();
    }

    private void setCurrentActionToStart() {
        this.currentAction = this.behavior.getSteps_Behaviour().stream().filter(StartAction.class::isInstance).findFirst().orElseThrow(() -> new IllegalStateException("This model does not have a start action."));
        this.finished = false;
    }

    @Override
    public boolean hasNext() {
        return !this.hasFinished() && this.currentAction != null;
    }

    @Override
    public AbstractAction next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There is no action after StopAction, or a successor action was not defined.");
        }
        AbstractAction result = this.currentAction;
        this.finished = result instanceof StopAction;
        this.currentAction = this.currentAction.getSuccessor_AbstractAction();
        return result;
    }
}

