/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.user;

import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.User;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.UserRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.UserInterpretationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.ProvidedRole;

public final class RequestProcessingContext {
    private final UserRequest userRequest;
    private final User user;
    private final ProvidedRole providedRole;
    private final AssemblyContext assemblyContext;
    private final UserInterpretationContext userInterpretationContext;

    private RequestProcessingContext(Builder builder) {
        this.userRequest = builder.userRequest;
        this.user = builder.user;
        this.providedRole = builder.providedRole;
        this.assemblyContext = builder.assemblyContext;
        this.userInterpretationContext = builder.userInterpretationContext;
    }

    public UserRequest getUserRequest() {
        return this.userRequest;
    }

    public User getUser() {
        return this.user;
    }

    public ProvidedRole getProvidedRole() {
        return this.providedRole;
    }

    public AssemblyContext getAssemblyContext() {
        return this.assemblyContext;
    }

    public UserInterpretationContext getUserInterpretationContext() {
        return this.userInterpretationContext;
    }

    public String getUserId() {
        return this.user.getId();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UserRequest userRequest;
        private User user;
        private ProvidedRole providedRole;
        private AssemblyContext assemblyContext;
        private UserInterpretationContext userInterpretationContext;

        private Builder() {
        }

        public Builder withUserRequest(UserRequest userRequest) {
            this.userRequest = userRequest;
            return this;
        }

        public Builder withUser(User user) {
            this.user = user;
            return this;
        }

        public Builder withProvidedRole(ProvidedRole providedRole) {
            this.providedRole = providedRole;
            return this;
        }

        public Builder withAssemblyContext(AssemblyContext assemblyContext) {
            this.assemblyContext = assemblyContext;
            return this;
        }

        public RequestProcessingContext build() {
            return new RequestProcessingContext(this);
        }

        public Builder withUserInterpretationContext(UserInterpretationContext userInterpretationContext) {
            this.userInterpretationContext = userInterpretationContext;
            return this;
        }
    }
}

