/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities;

import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.SEFFInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.User;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.UserContextEntityHolder;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;

public final class GeneralEntryRequest
extends UserContextEntityHolder {
    private final RequiredRole requiredRole;
    private final Signature signature;
    private final EList<VariableUsage> inputVariableUsages;
    private final EList<VariableUsage> outputVariableUsages;
    private final SEFFInterpretationContext requestFrom;

    private GeneralEntryRequest(Builder builder) {
        super(builder.user);
        this.requiredRole = builder.requiredRole;
        this.signature = builder.signature;
        this.inputVariableUsages = builder.inputVariableUsages;
        this.requestFrom = builder.requestFrom;
        this.outputVariableUsages = builder.outputVariableUsages;
    }

    public GeneralEntryRequest(User user, RequiredRole requiredRole, Signature signature, EList<VariableUsage> inputVariableUsages, SEFFInterpretationContext requestFrom, EList<VariableUsage> outputVariableUsages) {
        super(user);
        this.requiredRole = requiredRole;
        this.signature = signature;
        this.inputVariableUsages = inputVariableUsages;
        this.requestFrom = requestFrom;
        this.outputVariableUsages = outputVariableUsages;
    }

    public RequiredRole getRequiredRole() {
        return this.requiredRole;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public EList<VariableUsage> getInputVariableUsages() {
        return this.inputVariableUsages;
    }

    public SEFFInterpretationContext getRequestFrom() {
        return this.requestFrom;
    }

    public EList<VariableUsage> getOutputVariableUsages() {
        return this.outputVariableUsages;
    }

    public Builder update() {
        return GeneralEntryRequest.builder().withInputVariableUsages(this.inputVariableUsages).withRequestFrom(this.requestFrom).withRequiredRole(this.requiredRole).withSignature(this.signature).withUser(this.getUser());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private User user;
        private RequiredRole requiredRole;
        private Signature signature;
        private EList<VariableUsage> inputVariableUsages;
        private SEFFInterpretationContext requestFrom;
        private EList<VariableUsage> outputVariableUsages;

        private Builder() {
        }

        public Builder withUser(User user) {
            this.user = user;
            return this;
        }

        public Builder withRequiredRole(RequiredRole requiredRole) {
            this.requiredRole = requiredRole;
            return this;
        }

        public Builder withSignature(Signature signature) {
            this.signature = signature;
            return this;
        }

        public Builder withInputVariableUsages(EList<VariableUsage> inputVariableUsages) {
            this.inputVariableUsages = inputVariableUsages;
            return this;
        }

        public Builder withOutputVariableUsages(EList<VariableUsage> outputVariableUsages) {
            this.outputVariableUsages = outputVariableUsages;
            return this;
        }

        public Builder withRequestFrom(SEFFInterpretationContext requestFrom) {
            this.requestFrom = requestFrom;
            return this;
        }

        public GeneralEntryRequest build() {
            return new GeneralEntryRequest(this);
        }
    }
}

