/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.SeffBehaviorWrapper;
import org.palladiosimulator.analyzer.slingshot.common.utils.Logic;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;

public abstract class SeffBehaviorContextHolder {
    private final List<SeffBehaviorWrapper> behaviors;
    private final Optional<AbstractAction> successor;
    private final Optional<SeffBehaviorWrapper> parent;

    protected SeffBehaviorContextHolder(List<ResourceDemandingBehaviour> behaviors, Optional<AbstractAction> successor, Optional<SeffBehaviorWrapper> parent) {
        Preconditions.checkArgument((boolean)Logic.implies((boolean)successor.isPresent(), (boolean)parent.isPresent()));
        this.behaviors = behaviors.stream().map(behavior -> new SeffBehaviorWrapper((ResourceDemandingBehaviour)behavior, this)).collect(Collectors.toList());
        this.successor = successor;
        this.parent = parent;
    }

    public Optional<AbstractAction> getSuccessor() {
        return this.successor;
    }

    public boolean hasFinished() {
        return !this.behaviors.stream().anyMatch(holder -> !holder.hasFinished());
    }

    public Optional<SeffBehaviorWrapper> getParent() {
        return this.parent;
    }

    public boolean isChild() {
        return this.parent.isPresent();
    }

    public Entity getNextAction() {
        if (this.hasFinished()) {
            throw new NoSuchElementException("There is no action to interpret anymore, as this model has finished.");
        }
        return this.getCurrentProcessedBehavior().next();
    }

    protected List<SeffBehaviorWrapper> getBehaviors() {
        return this.behaviors;
    }

    public abstract SeffBehaviorWrapper getCurrentProcessedBehavior();
}

