/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.monitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.monitor.probes.NumberOfElementsInCompetingConsumerGroupProbe;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.monitor.probes.NumberOfElementsInServiceGroupProbe;
import org.palladiosimulator.analyzer.slingshot.common.annotations.Nullable;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.common.events.modelchanges.ModelAdjusted;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.analyzer.slingshot.monitor.data.entities.ProbeTakenEntity;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.CalculatorRegistered;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.ProbeTaken;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MeasurementSpecificationVisited;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MonitorModelVisited;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.semanticspd.CompetingConsumersGroupCfg;
import org.palladiosimulator.semanticspd.Configuration;
import org.palladiosimulator.semanticspd.ServiceGroupCfg;
import org.palladiosimulator.spdmeasuringpoint.CompetingConsumerGroupMeasuringPoint;
import org.palladiosimulator.spdmeasuringpoint.ServiceGroupMeasuringPoint;

@OnEvent.OnEvents(value={@OnEvent(when=MonitorModelVisited.class, then={CalculatorRegistered.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=ModelAdjusted.class, then={ProbeTaken.class}, cardinality=EventCardinality.SINGLE)})
public class NumberOfElementsMonitorBehavior
implements SimulationBehaviorExtension {
    private final IGenericCalculatorFactory calculatorFactory;
    private final Configuration semanticConfiguration;
    private final Map<AssemblyContext, NumberOfElementsInServiceGroupProbe> serviceGroupProbes = new HashMap<AssemblyContext, NumberOfElementsInServiceGroupProbe>();
    private final Map<AssemblyContext, NumberOfElementsInCompetingConsumerGroupProbe> competingConsumerProbes = new HashMap<AssemblyContext, NumberOfElementsInCompetingConsumerGroupProbe>();

    @Inject
    public NumberOfElementsMonitorBehavior(IGenericCalculatorFactory calculatorFactory, @Nullable Configuration semanticConfiguration) {
        this.calculatorFactory = calculatorFactory;
        this.semanticConfiguration = semanticConfiguration;
    }

    public boolean isActive() {
        return this.semanticConfiguration != null && !this.semanticConfiguration.getTargetCfgs().isEmpty();
    }

    @Subscribe
    public Result<CalculatorRegistered> onMeasurementSpecification(MeasurementSpecificationVisited m) {
        MeasurementSpecification spec = (MeasurementSpecification)m.getEntity();
        MeasuringPoint measuringPoint = spec.getMonitor().getMeasuringPoint();
        if (measuringPoint instanceof ServiceGroupMeasuringPoint var4_5 && MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)spec.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS) && ((Optional)(sgCalculator = this.regsterSGCalculator((ServiceGroupMeasuringPoint)mp))).isPresent()) {
            return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered((Calculator)((Optional)sgCalculator).get())});
        }
         instanceOfPatternExpressionValue = measuringPoint;
        if ( instanceOfPatternExpressionValue instanceof CompetingConsumerGroupMeasuringPoint && (sgCalculator = (CompetingConsumerGroupMeasuringPoint) instanceOfPatternExpressionValue) == (CompetingConsumerGroupMeasuringPoint) instanceOfPatternExpressionValue && MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)spec.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS) && (ccgCalculator = this.registerCCGCalculator((CompetingConsumerGroupMeasuringPoint)mp)).isPresent()) {
            return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered(ccgCalculator.get())});
        }
        return Result.empty();
    }

    private Optional<Calculator> registerCCGCalculator(CompetingConsumerGroupMeasuringPoint assemblyContextMeasuringPoint) {
        Optional<CompetingConsumersGroupCfg> competingConsumerGroupCfg = this.semanticConfiguration.getTargetCfgs().stream().filter(cfg -> cfg instanceof CompetingConsumersGroupCfg).map(eicfg -> (CompetingConsumersGroupCfg)eicfg).filter(eicfg -> eicfg.getUnit().getId().equals(assemblyContextMeasuringPoint.getCompetingConsumerGroup().getUnitAssembly().getId())).findAny();
        if (competingConsumerGroupCfg.isPresent()) {
            Calculator calculator = this.setupNumberOfElementsCalculator((MeasuringPoint)assemblyContextMeasuringPoint, this.calculatorFactory, competingConsumerGroupCfg.get());
            return Optional.of(calculator);
        }
        return Optional.empty();
    }

    private Optional<Calculator> regsterSGCalculator(ServiceGroupMeasuringPoint assemblyContextMeasuringPoint) {
        Optional<ServiceGroupCfg> serviceGroupCfg = this.semanticConfiguration.getTargetCfgs().stream().filter(cfg -> cfg instanceof ServiceGroupCfg).map(eicfg -> (ServiceGroupCfg)eicfg).filter(eicfg -> eicfg.getUnit().getId().equals(assemblyContextMeasuringPoint.getServiceGroup().getUnitAssembly().getId())).findAny();
        if (serviceGroupCfg.isPresent()) {
            Calculator calculator = this.setupNumberOfElementsCalculator((MeasuringPoint)assemblyContextMeasuringPoint, this.calculatorFactory, serviceGroupCfg.get());
            return Optional.of(calculator);
        }
        return Optional.empty();
    }

    @Subscribe
    public Result<ProbeTaken> onModelAdjusted(ModelAdjusted stateUpdated) {
        HashSet<ProbeTaken> probesTaken = new HashSet<ProbeTaken>();
        for (NumberOfElementsInServiceGroupProbe numberOfElementsInServiceGroupProbe : this.serviceGroupProbes.values()) {
            numberOfElementsInServiceGroupProbe.takeMeasurement((DESEvent)stateUpdated);
            probesTaken.add(new ProbeTaken(ProbeTakenEntity.builder().withProbe((Probe)numberOfElementsInServiceGroupProbe).build()));
        }
        for (NumberOfElementsInCompetingConsumerGroupProbe numberOfElementsInCompetingConsumerGroupProbe : this.competingConsumerProbes.values()) {
            numberOfElementsInCompetingConsumerGroupProbe.takeMeasurement((DESEvent)stateUpdated);
            probesTaken.add(new ProbeTaken(ProbeTakenEntity.builder().withProbe((Probe)numberOfElementsInCompetingConsumerGroupProbe).build()));
        }
        return Result.of(probesTaken);
    }

    public Calculator setupNumberOfElementsCalculator(MeasuringPoint measuringPoint, IGenericCalculatorFactory calculatorFactory, ServiceGroupCfg sgCfg) {
        this.serviceGroupProbes.putIfAbsent(sgCfg.getUnit(), new NumberOfElementsInServiceGroupProbe(sgCfg));
        NumberOfElementsInServiceGroupProbe probe = this.serviceGroupProbes.get(sgCfg.getUnit());
        return calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS_OVER_TIME, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)probe));
    }

    public Calculator setupNumberOfElementsCalculator(MeasuringPoint measuringPoint, IGenericCalculatorFactory calculatorFactory, CompetingConsumersGroupCfg sgCfg) {
        this.competingConsumerProbes.putIfAbsent(sgCfg.getUnit(), new NumberOfElementsInCompetingConsumerGroupProbe(sgCfg));
        NumberOfElementsInCompetingConsumerGroupProbe probe = this.competingConsumerProbes.get(sgCfg.getUnit());
        return calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS_OVER_TIME, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)probe));
    }
}

