/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.monitor;

import java.util.Objects;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.CallOverWireRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.SEFFInterpretationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;

public final class AssemblyOperationCompoundKey {
    private final AssemblyContext assemblyContext;
    private final ProvidedRole providedRole;
    private final Signature signature;

    private AssemblyOperationCompoundKey(AssemblyContext assemblyContext, ProvidedRole providedRole, Signature signature) {
        this.assemblyContext = assemblyContext;
        this.providedRole = providedRole;
        this.signature = signature;
    }

    public int hashCode() {
        return Objects.hash(this.assemblyContext.getId(), this.providedRole.getId(), this.signature.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssemblyOperationCompoundKey)) {
            return false;
        }
        AssemblyOperationCompoundKey other = (AssemblyOperationCompoundKey)obj;
        return Objects.equals(this.assemblyContext.getId(), other.assemblyContext.getId()) && Objects.equals(this.providedRole.getId(), other.providedRole.getId()) && Objects.equals(this.signature.getId(), other.signature.getId());
    }

    public String toString() {
        return String.valueOf(this.assemblyContext.getId()) + ":" + this.providedRole.getId();
    }

    public static AssemblyOperationCompoundKey of(SEFFInterpretationContext context) {
        OperationSignature sig = null;
        if (context.getRequestProcessingContext().getUserRequest() != null) {
            sig = context.getRequestProcessingContext().getUserRequest().getOperationSignature();
        } else if (context.getCallOverWireRequest().isPresent()) {
            sig = ((CallOverWireRequest)context.getCallOverWireRequest().get()).getSignature();
        } else {
            throw new IllegalArgumentException(String.format("Cannot determine Signature of SEFFInterpretationContext %s, as their is neither a UserRequest, nor a CallOverWireRequest.", context.toString()));
        }
        return new AssemblyOperationCompoundKey(context.getAssemblyContext(), context.getRequestProcessingContext().getProvidedRole(), (Signature)sig);
    }

    public static AssemblyOperationCompoundKey of(AssemblyContext assemblyContext, ProvidedRole providedRole, Signature signature) {
        return new AssemblyOperationCompoundKey(assemblyContext, providedRole, signature);
    }
}

