/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.monitor;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.SEFFInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFModelPassedElement;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.monitor.AssemblyOperationCompoundKey;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.analyzer.slingshot.monitor.data.entities.ProbeTakenEntity;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.CalculatorRegistered;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.ProbeTaken;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MeasurementSpecificationVisited;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MonitorModelVisited;
import org.palladiosimulator.analyzer.slingshot.monitor.utils.probes.EventCurrentSimulationTimeProbe;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyOperationMeasuringPoint;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.Probe;

@OnEvent.OnEvents(value={@OnEvent(when=MonitorModelVisited.class, then={CalculatorRegistered.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=SEFFModelPassedElement.class, then={ProbeTaken.class}, cardinality=EventCardinality.SINGLE)})
public class OperationCallActionResponseTimeMonitoringBehavior
implements SimulationBehaviorExtension {
    private final IGenericCalculatorFactory calculatorFactory;
    private final Map<AssemblyOperationCompoundKey, OperationProbes> userProbesMap = new HashMap<AssemblyOperationCompoundKey, OperationProbes>();

    @Inject
    public OperationCallActionResponseTimeMonitoringBehavior(IGenericCalculatorFactory calculatorFactory) {
        this.calculatorFactory = calculatorFactory;
    }

    @Subscribe
    public Result<CalculatorRegistered> onMeasurementSpecificationVisited(MeasurementSpecificationVisited event) {
        MeasurementSpecification measurementSpecification = (MeasurementSpecification)event.getEntity();
        MeasuringPoint measuringPoint = measurementSpecification.getMonitor().getMeasuringPoint();
        if (measuringPoint instanceof AssemblyOperationMeasuringPoint var4_5 && MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)measurementSpecification.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC) && ( instanceOfPatternExpressionValue = assemblyMeasuringPoint.getRole()) instanceof OperationProvidedRole && (var6_7 = (OperationProvidedRole) instanceOfPatternExpressionValue) == (OperationProvidedRole) instanceOfPatternExpressionValue) {
            OperationProbes userProbes = new OperationProbes();
            AssemblyOperationCompoundKey key = AssemblyOperationCompoundKey.of(assemblyMeasuringPoint.getAssembly(), (ProvidedRole)role, (Signature)assemblyMeasuringPoint.getOperationSignature());
            this.userProbesMap.put(key, userProbes);
            Calculator calculator = this.calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC_TUPLE, (MeasuringPoint)assemblyMeasuringPoint, DefaultCalculatorProbeSets.createStartStopProbeConfiguration((Probe)userProbes.operationStartedProbe, (Probe)userProbes.operationFinishedProbe));
            return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered(calculator)});
        }
        return Result.empty();
    }

    @Subscribe(reified={StartAction.class})
    public Result<ProbeTaken> onOperationCallStarted(SEFFModelPassedElement<StartAction> seffStarted) {
        if (seffStarted.getContext().getBehaviorContext().isChild()) {
            return Result.empty();
        }
        ProvidedRole role = seffStarted.getContext().getRequestProcessingContext().getProvidedRole();
        AssemblyOperationCompoundKey key = AssemblyOperationCompoundKey.of(seffStarted.getContext());
        if (role instanceof OperationProvidedRole && this.userProbesMap.containsKey(key)) {
            OperationProbes userProbes = this.userProbesMap.get(key);
            userProbes.operationStartedProbe.takeMeasurement(seffStarted);
            return Result.of((Object[])new ProbeTaken[]{new ProbeTaken(ProbeTakenEntity.builder().withProbe((Probe)userProbes.operationStartedProbe).build())});
        }
        return Result.empty();
    }

    @Subscribe(reified={StopAction.class})
    public Result<ProbeTaken> onOperationCallStopped(SEFFModelPassedElement<StopAction> seffFinished) {
        if (seffFinished.getContext().getBehaviorContext().isChild()) {
            return Result.empty();
        }
        ProvidedRole role = seffFinished.getContext().getRequestProcessingContext().getProvidedRole();
        AssemblyOperationCompoundKey key = AssemblyOperationCompoundKey.of(seffFinished.getContext());
        if (role instanceof OperationProvidedRole && this.userProbesMap.containsKey(key)) {
            OperationProbes userProbes = this.userProbesMap.get(key);
            userProbes.operationFinishedProbe.takeMeasurement(seffFinished);
            return Result.of((Object[])new ProbeTaken[]{new ProbeTaken(ProbeTakenEntity.builder().withProbe((Probe)userProbes.operationFinishedProbe).build())});
        }
        return Result.empty();
    }

    private static final class OperationProbes {
        private final EventCurrentSimulationTimeProbe operationStartedProbe = new EventCurrentSimulationTimeProbe(OperationProbes::passedElement);
        private final EventCurrentSimulationTimeProbe operationFinishedProbe = new EventCurrentSimulationTimeProbe(OperationProbes::passedElement);

        private OperationProbes() {
        }

        private static RequestContext passedElement(DESEvent desEvent) {
            if (desEvent instanceof SEFFModelPassedElement) {
                SEFFModelPassedElement el = (SEFFModelPassedElement)desEvent;
                if (el.getContext().getCaller().isPresent()) {
                    return new RequestContext(String.valueOf(el.getContext().getRequestProcessingContext().getUser().getId()) + ((SEFFInterpretationContext)el.getContext().getCaller().get()).hashCode());
                }
                return new RequestContext(el.getContext().getRequestProcessingContext().getUser().getId());
            }
            return RequestContext.EMPTY_REQUEST_CONTEXT;
        }
    }
}

