/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.interpreters;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.GeneralEntryRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.ResourceDemandRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.SEFFInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.BranchBehaviorContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.ForkBehaviorContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.InfrastructureCallsContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.LoopBehaviorContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.SeffBehaviorContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.PassiveResourceReleased;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.ResourceDemandRequested;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFChildInterpretationStarted;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFExternalActionCalled;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFInfrastructureCalled;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFInterpretationFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFInterpretationProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFInterpreted;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFModelPassedElement;
import org.palladiosimulator.analyzer.slingshot.common.utils.SimulatedStackHelper;
import org.palladiosimulator.analyzer.slingshot.common.utils.TransitionDeterminer;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CallAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;

public class SeffInterpreter
extends SeffSwitch<Set<SEFFInterpreted>> {
    private static final Logger LOGGER = Logger.getLogger(SeffInterpreter.class);
    private final SEFFInterpretationContext context;

    public SeffInterpreter(SEFFInterpretationContext context) {
        this.context = context;
    }

    public Set<SEFFInterpreted> caseStopAction(StopAction object) {
        LOGGER.debug((Object)"Seff stopped.");
        return Set.of(new SEFFInterpretationFinished(this.context), new SEFFModelPassedElement((EObject)object, this.context));
    }

    public Set<SEFFInterpreted> caseBranchAction(BranchAction branchAction) {
        EList abstractBranchTransitions = branchAction.getBranches_Branch();
        if (abstractBranchTransitions.isEmpty()) {
            throw new IllegalStateException("Empty branch action is not allowed!");
        }
        TransitionDeterminer transitionDeterminer = new TransitionDeterminer(this.context.getRequestProcessingContext().getUser().getStack().currentStackFrame());
        AbstractBranchTransition branchTransition = transitionDeterminer.determineTransition(abstractBranchTransitions);
        if (branchTransition == null) {
            throw new IllegalStateException("No branch transition was active. This is not allowed.");
        }
        LOGGER.info((Object)String.format("Branch chosen: %s with id %s", branchTransition.getEntityName(), branchTransition.getId()));
        BranchBehaviorContextHolder holder = new BranchBehaviorContextHolder(branchTransition.getBranchBehaviour_BranchTransition(), branchAction.getSuccessor_AbstractAction(), this.context.getBehaviorContext().getCurrentProcessedBehavior());
        SEFFInterpretationContext childContext = this.context.createChildContext().withBehaviorContext((SeffBehaviorContextHolder)holder).withRequestProcessingContext(this.context.getRequestProcessingContext()).withAssemblyContext(this.context.getAssemblyContext()).build();
        SEFFChildInterpretationStarted event = new SEFFChildInterpretationStarted(childContext);
        return Set.of(event);
    }

    public Set<SEFFInterpreted> caseStartAction(StartAction object) {
        LOGGER.debug((Object)"Found starting action of SEFF");
        return Set.of(new SEFFInterpretationProgressed(this.context), new SEFFModelPassedElement((EObject)object, this.context));
    }

    public Set<SEFFInterpreted> caseLoopAction(LoopAction object) {
        int iterationCount = (Integer)StackContext.evaluateStatic((String)object.getIterationCount_LoopAction().getSpecification(), Integer.class, (SimulatedStackframe)this.context.getRequestProcessingContext().getUser().getStack().currentStackFrame());
        LOGGER.info((Object)("LoopAction: Count " + iterationCount));
        LoopBehaviorContextHolder holder = new LoopBehaviorContextHolder(object.getBodyBehaviour_Loop(), object.getSuccessor_AbstractAction(), this.context.getBehaviorContext().getCurrentProcessedBehavior(), iterationCount);
        SEFFInterpretationContext childContext = this.context.createChildContext().withBehaviorContext((SeffBehaviorContextHolder)holder).withRequestProcessingContext(this.context.getRequestProcessingContext()).withCaller(this.context.getCaller()).withAssemblyContext(this.context.getAssemblyContext()).build();
        return Set.of(new SEFFChildInterpretationStarted(childContext));
    }

    public Set<SEFFInterpreted> caseForkAction(ForkAction object) {
        if (object.getSynchronisingBehaviours_ForkAction() == null) {
            throw new IllegalStateException("ForkAction must have a synchronisation point!");
        }
        EList forkedBehaviors = object.getSynchronisingBehaviours_ForkAction().getSynchronousForkedBehaviours_SynchronisationPoint();
        List rdBehaviors = forkedBehaviors.stream().map(b -> b).collect(Collectors.toList());
        if (forkedBehaviors.isEmpty()) {
            throw new IllegalStateException("Empty forked behaviors is not allowed");
        }
        ForkBehaviorContextHolder forkedBehaviorContext = new ForkBehaviorContextHolder(rdBehaviors, object.getSuccessor_AbstractAction(), this.context.getBehaviorContext().getCurrentProcessedBehavior());
        List childContexts = rdBehaviors.stream().map(rdBehavior -> this.context.createChildContext().withBehaviorContext((SeffBehaviorContextHolder)forkedBehaviorContext).withRequestProcessingContext(this.context.getRequestProcessingContext()).withCaller(this.context.getCaller()).withAssemblyContext(this.context.getAssemblyContext()).build()).collect(Collectors.toList());
        return childContexts.stream().map(SEFFChildInterpretationStarted::new).collect(Collectors.toSet());
    }

    public Set<SEFFInterpreted> caseExternalCallAction(ExternalCallAction externalCall) {
        OperationRequiredRole requiredRole = externalCall.getRole_ExternalService();
        OperationSignature calledServiceSignature = externalCall.getCalledService_ExternalService();
        EList inputVariableUsages = externalCall.getInputVariableUsages__CallAction();
        EList outputVariableUsages = externalCall.getReturnVariableUsage__CallReturnAction();
        GeneralEntryRequest entryRequest = GeneralEntryRequest.builder().withInputVariableUsages(inputVariableUsages).withOutputVariableUsages(outputVariableUsages).withRequiredRole((RequiredRole)requiredRole).withSignature((Signature)calledServiceSignature).withUser(this.context.getRequestProcessingContext().getUser()).withRequestFrom(this.context.update().build()).build();
        return Set.of(new SEFFExternalActionCalled(entryRequest));
    }

    public Set<SEFFInterpreted> caseAcquireAction(AcquireAction object) {
        ParametricResourceDemand demand = (ParametricResourceDemand)object.getResourceDemand_Action().stream().findFirst().orElseThrow(() -> new NoSuchElementException("No parametric resource demand specified for AcquireAction!"));
        ResourceDemandRequest request = ResourceDemandRequest.builder().withAssemblyContext(this.context.getAssemblyContext()).withPassiveResource(object.getPassiveresource_AcquireAction()).withResourceType(ResourceDemandRequest.ResourceType.PASSIVE).withSeffInterpretationContext(this.context).withParametricResourceDemand(demand).build();
        return Set.of(new ResourceDemandRequested(request));
    }

    public Set<SEFFInterpreted> caseReleaseAction(ReleaseAction object) {
        ParametricResourceDemand demand = (ParametricResourceDemand)object.getResourceDemand_Action().stream().findFirst().orElseThrow(() -> new NoSuchElementException("No parametric resource demand specified for ReleaseAction!"));
        ResourceDemandRequest request = ResourceDemandRequest.builder().withResourceType(ResourceDemandRequest.ResourceType.PASSIVE).withSeffInterpretationContext(this.context).withAssemblyContext(this.context.getAssemblyContext()).withPassiveResource(object.getPassiveResource_ReleaseAction()).withParametricResourceDemand(demand).build();
        return Set.of(new PassiveResourceReleased(request, 0.0), new SEFFInterpretationProgressed(this.context));
    }

    public Set<SEFFInterpreted> caseCollectionIteratorAction(CollectionIteratorAction object) {
        Parameter parameter = object.getParameter_CollectionIteratorAction();
        String idNumberOfLoops = String.valueOf(parameter.getParameterName()) + ".NUMBER_OF_ELEMENTS";
        int iterationCount = (Integer)StackContext.evaluateStatic((String)idNumberOfLoops, Integer.class, (SimulatedStackframe)this.context.getRequestProcessingContext().getUser().getStack().currentStackFrame());
        SimulatedStackframe innerVariableStackFrame = this.context.getRequestProcessingContext().getUser().getStack().createAndPushNewStackFrame(this.context.getRequestProcessingContext().getUser().getStack().currentStackFrame());
        this.context.getRequestProcessingContext().getUser().evaluateInner(innerVariableStackFrame, String.valueOf(parameter.getParameterName()) + ".");
        LoopBehaviorContextHolder holder = new LoopBehaviorContextHolder(object.getBodyBehaviour_Loop(), object.getSuccessor_AbstractAction(), this.context.getBehaviorContext().getCurrentProcessedBehavior(), iterationCount);
        SEFFInterpretationContext newContext = this.context.createChildContextPrefilled().withBehaviorContext((SeffBehaviorContextHolder)holder).build();
        return Set.of(new SEFFChildInterpretationStarted(newContext));
    }

    public Set<SEFFInterpreted> caseSetVariableAction(SetVariableAction object) {
        SimulatedStack stack = this.context.getRequestProcessingContext().getUser().getStack();
        SimulatedStackframe stackFrame = stack.currentStackFrame();
        SimulatedStackframe resultStackframe = this.context.getCurrentResultStackframe();
        SimulatedStackHelper.addParameterToStackFrame((SimulatedStackframe)stackFrame, (EList)object.getLocalVariableUsages_SetVariableAction(), (SimulatedStackframe)resultStackframe);
        return Set.of(new SEFFInterpretationProgressed(this.context));
    }

    public Set<SEFFInterpreted> caseCallAction(CallAction callAction) {
        if (callAction instanceof InfrastructureCall) {
            InfrastructureCall call = (InfrastructureCall)callAction;
            GeneralEntryRequest request = GeneralEntryRequest.builder().withInputVariableUsages(call.getInputVariableUsages__CallAction()).withRequiredRole((RequiredRole)call.getRequiredRole__InfrastructureCall()).withSignature((Signature)call.getSignature__InfrastructureCall()).withUser(this.context.getRequestProcessingContext().getUser()).withRequestFrom(this.context.update().build()).build();
            return Set.of(new SEFFInfrastructureCalled(request));
        }
        LOGGER.warn((Object)"Attention, no interpreation implemented for this specific CallAction, it is simply ignored!");
        return Set.of();
    }

    public Set<SEFFInterpreted> caseInternalAction(InternalAction internalAction) {
        LOGGER.debug((Object)"Found internal action");
        HashSet<SEFFInterpretationProgressed> events = new HashSet<SEFFInterpretationProgressed>();
        internalAction.getResourceDemand_Action().forEach(demand -> {
            LOGGER.debug((Object)("Demand found with: " + demand));
            ResourceDemandRequest request = ResourceDemandRequest.builder().withAssemblyContext(this.context.getAssemblyContext()).withSeffInterpretationContext(this.context).withResourceType(ResourceDemandRequest.ResourceType.ACTIVE).withParametricResourceDemand(demand).build();
            ResourceDemandRequested requestEvent = new ResourceDemandRequested(request);
            events.add((SEFFInterpretationProgressed)requestEvent);
        });
        if (events.isEmpty() && !internalAction.getInfrastructureCall__Action().isEmpty()) {
            InfrastructureCallsContextHolder infraContext = new InfrastructureCallsContextHolder(this.context, internalAction, this.context.getBehaviorContext().getCurrentProcessedBehavior());
            SEFFInterpretationContext infraChildContext = this.context.createChildContext().withBehaviorContext((SeffBehaviorContextHolder)infraContext).withRequestProcessingContext(this.context.getRequestProcessingContext()).withCaller(this.context.getCaller()).withAssemblyContext(this.context.getAssemblyContext()).build();
            events.add(new SEFFInterpretationProgressed(infraChildContext));
        }
        if (events.isEmpty()) {
            events.add(new SEFFInterpretationProgressed(this.context));
        }
        return Collections.unmodifiableSet(events);
    }

    public Set<SEFFInterpreted> doSwitch(EClass eClass, EObject eObject) {
        if (eObject == null) {
            throw new IllegalArgumentException("called interpretation on a null reference");
        }
        Set<SEFFInterpreted> result = (Set<SEFFInterpreted>)super.doSwitch(eClass, eObject);
        if (result == null) {
            result = Set.of();
        }
        return result;
    }
}

