/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.interpreters;

import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.CallOverWireRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.SEFFInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.RootBehaviorContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.SeffBehaviorContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.user.RequestProcessingContext;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFInterpretationProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.repository.SystemModelRepository;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.User;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.UserRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.UserInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.common.utils.SimulatedStackHelper;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.CompositionPackage;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.EntityPackage;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.util.RepositorySwitch;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;

public class RepositoryInterpreter
extends RepositorySwitch<Set<SEFFInterpretationProgressed>> {
    private static final Logger LOGGER = Logger.getLogger(RepositoryInterpreter.class);
    private final AssemblyContext assemblyContext;
    private final ProvidedRole providedRole;
    private final Signature signature;
    private final User user;
    private final SystemModelRepository modelRepository;
    private final Optional<SEFFInterpretationContext> callerContext;
    private final CallOverWireRequest callOverWireRequest;
    private final UserInterpretationContext userInterpretationContext;
    private final UserRequest userRequest;
    private final SimulatedStackframe<Object> resultStackframe;

    public RepositoryInterpreter(AssemblyContext context, Signature signature, ProvidedRole providedRole, User user, SystemModelRepository modelRepository, Optional<SEFFInterpretationContext> callerContext, CallOverWireRequest request, SimulatedStackframe<Object> resultStackframe) {
        this(context, signature, providedRole, user, modelRepository, callerContext, request, resultStackframe, null, null);
    }

    public RepositoryInterpreter(AssemblyContext context, Signature signature, ProvidedRole providedRole, User user, SystemModelRepository modelRepository, Optional<SEFFInterpretationContext> callerContext, CallOverWireRequest request, SimulatedStackframe<Object> resultStackframe, UserInterpretationContext userInterpretationContext, UserRequest userRequest) {
        this.assemblyContext = context;
        this.signature = signature;
        this.providedRole = providedRole;
        this.user = user;
        this.modelRepository = modelRepository;
        this.callerContext = callerContext;
        this.callOverWireRequest = request;
        this.resultStackframe = resultStackframe;
        this.userInterpretationContext = userInterpretationContext;
        this.userRequest = userRequest;
    }

    public Set<SEFFInterpretationProgressed> caseBasicComponent(BasicComponent object) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entering BasicComponent: " + object));
        }
        SimulatedStackframe componentParameterStackframe = SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack)this.user.getStack(), (EList)object.getComponentParameterUsage_ImplementationComponentType(), (SimulatedStackframe)this.user.getStack().currentStackFrame());
        SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack)this.user.getStack(), (EList)this.assemblyContext.getConfigParameterUsages__AssemblyContext(), (SimulatedStackframe)componentParameterStackframe);
        List<ServiceEffectSpecification> calledSeffs = this.getSeffsForCall((EList<ServiceEffectSpecification>)object.getServiceEffectSpecifications__BasicComponent(), this.signature);
        return calledSeffs.stream().filter(ResourceDemandingSEFF.class::isInstance).map(ResourceDemandingSEFF.class::cast).map(rdSeff -> {
            SEFFInterpretationContext context = SEFFInterpretationContext.builder().withAssemblyContext(this.assemblyContext).withCaller(this.callerContext).withBehaviorContext((SeffBehaviorContextHolder)new RootBehaviorContextHolder((ResourceDemandingBehaviour)rdSeff)).withRequestProcessingContext(RequestProcessingContext.builder().withAssemblyContext(this.assemblyContext).withProvidedRole(this.providedRole).withUser(this.user).withUserInterpretationContext(this.userInterpretationContext).withUserRequest(this.userRequest).build()).withCallOverWireRequest(this.callOverWireRequest).withResultStackframe(this.resultStackframe).build();
            return new SEFFInterpretationProgressed(context);
        }).collect(Collectors.toSet());
    }

    private List<ServiceEffectSpecification> getSeffsForCall(EList<ServiceEffectSpecification> serviceEffectSpecifications, Signature operationSignature) {
        assert (serviceEffectSpecifications != null && operationSignature != null);
        return serviceEffectSpecifications.stream().filter(seff -> seff.getDescribedService__SEFF().getId().equals(operationSignature.getId())).collect(Collectors.toList());
    }

    public Set<SEFFInterpretationProgressed> caseProvidedRole(ProvidedRole providedRole) {
        LOGGER.debug((Object)("Accessing provided role: " + providedRole.getId()));
        return (Set)this.doSwitch((EObject)providedRole.getProvidingEntity_ProvidedRole());
    }

    public Set<SEFFInterpretationProgressed> caseComposedProvidingRequiringEntity(ComposedProvidingRequiringEntity entity) {
        if (entity != this.providedRole.getProvidingEntity_ProvidedRole()) {
            return Set.of();
        }
        ProvidedDelegationConnector connectedProvidedDelegationConnector = this.getConnectedProvidedDelegationConnector().orElseThrow(IllegalStateException::new);
        RepositoryInterpreter repositoryInterpreter = new RepositoryInterpreter(connectedProvidedDelegationConnector.getAssemblyContext_ProvidedDelegationConnector(), this.signature, (ProvidedRole)connectedProvidedDelegationConnector.getInnerProvidedRole_ProvidedDelegationConnector(), this.user, this.modelRepository, Optional.empty(), this.callOverWireRequest, this.resultStackframe);
        return (Set)repositoryInterpreter.doSwitch((EObject)connectedProvidedDelegationConnector.getInnerProvidedRole_ProvidedDelegationConnector());
    }

    private Optional<ProvidedDelegationConnector> getConnectedProvidedDelegationConnector() {
        InterfaceProvidingEntity implementingEntity = this.providedRole.getProvidingEntity_ProvidedRole();
        assert (implementingEntity instanceof ComposedStructure);
        ComposedStructure composedStructure = (ComposedStructure)implementingEntity;
        return composedStructure.getConnectors__ComposedStructure().stream().filter(connector -> connector.eClass() == CompositionPackage.eINSTANCE.getProvidedDelegationConnector()).map(ProvidedDelegationConnector.class::cast).filter(delegationConnector -> delegationConnector.getOuterProvidedRole_ProvidedDelegationConnector().getId().equals(this.providedRole.getId())).findFirst();
    }

    public Set<SEFFInterpretationProgressed> doSwitch(EClass eClass, EObject eObject) {
        Set<Object> result = EntityPackage.eINSTANCE.getComposedProvidingRequiringEntity().isSuperTypeOf(eClass) ? this.caseComposedProvidingRequiringEntity((ComposedProvidingRequiringEntity)eObject) : (Set)super.doSwitch(eClass, eObject);
        if (result == null) {
            result = Set.of();
        }
        return result;
    }
}

