/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.repository;

import java.util.Optional;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.repository.SystemModelRepository;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.system.System;

public class SystemModelRepositoryImpl
implements SystemModelRepository {
    private static final Logger LOGGER = Logger.getLogger(SystemModelRepositoryImpl.class);
    private System systemModel;

    @Override
    public void load(System system) {
        this.systemModel = system;
    }

    @Override
    public Optional<ServiceEffectSpecification> findSeffFromRequiredRole(RequiredRole requiredRole, Signature signature) {
        return this.systemModel.getConnectors__ComposedStructure().stream().filter(connector -> connector instanceof AssemblyConnector).map(connector -> (AssemblyConnector)connector).filter(assemblyConnector -> assemblyConnector.getRequiredRole_AssemblyConnector().getId().equals(requiredRole.getId())).map(AssemblyConnector::getProvidingAssemblyContext_AssemblyConnector).map(AssemblyContext::getEncapsulatedComponent__AssemblyContext).filter(BasicComponent.class::isInstance).map(BasicComponent.class::cast).map(component -> this.getSeffFromBasicComponent((BasicComponent)component, signature)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<AssemblyContext> findAssemblyContextFromRepositoryComponent(RepositoryComponent component) {
        return this.systemModel.getAssemblyContexts__ComposedStructure().stream().filter(context -> context.getEncapsulatedComponent__AssemblyContext().getId().equals(component.getId())).findFirst();
    }

    @Override
    public Optional<AssemblyContext> findAssemblyContextFromRequiredRole(RequiredRole requiredRole) {
        return this.systemModel.getConnectors__ComposedStructure().stream().filter(connector -> connector instanceof AssemblyConnector).map(connector -> (AssemblyConnector)connector).filter(assemblyConnector -> assemblyConnector.getRequiredRole_AssemblyConnector().getId().equals(requiredRole.getId())).map(AssemblyConnector::getProvidingAssemblyContext_AssemblyConnector).findFirst();
    }

    @Override
    public Optional<OperationProvidedRole> findProvidedRoleFromRequiredRole(RequiredRole requiredRole) {
        return this.systemModel.getConnectors__ComposedStructure().stream().filter(connector -> connector instanceof AssemblyConnector).map(connector -> (AssemblyConnector)connector).filter(assemblyConnector -> assemblyConnector.getRequiredRole_AssemblyConnector().getId().equals(requiredRole.getId())).map(AssemblyConnector::getProvidedRole_AssemblyConnector).findFirst();
    }

    @Override
    public Optional<AssemblyContext> findInfrastructureAssemblyContextFromRequiredRole(RequiredRole requiredRole) {
        return this.systemModel.getConnectors__ComposedStructure().stream().filter(connector -> connector instanceof AssemblyInfrastructureConnector).map(connector -> (AssemblyInfrastructureConnector)connector).filter(assemblyInfraConnector -> assemblyInfraConnector.getRequiredRole__AssemblyInfrastructureConnector().getId().equals(requiredRole.getId())).map(AssemblyInfrastructureConnector::getProvidingAssemblyContext__AssemblyInfrastructureConnector).findFirst();
    }

    @Override
    public Optional<ProvidedDelegationConnector> getConnectedProvidedDelegationConnector(ProvidedRole providedRole) {
        this.systemModel.getProvidedRoles_InterfaceProvidingEntity();
        boolean providedRolePresent = this.systemModel.getProvidedRoles_InterfaceProvidingEntity().stream().filter(systemProvidedRole -> systemProvidedRole.getId().equals(providedRole.getId())).findFirst().isPresent();
        if (!providedRolePresent) {
            return Optional.empty();
        }
        LOGGER.debug((Object)("Provided Role is present: " + providedRole.getEntityName()));
        return this.systemModel.getConnectors__ComposedStructure().stream().filter(ProvidedDelegationConnector.class::isInstance).map(ProvidedDelegationConnector.class::cast).filter(connector -> connector.getOuterProvidedRole_ProvidedDelegationConnector().getId().equals(providedRole.getId())).findFirst();
    }

    @Override
    public Optional<ServiceEffectSpecification> getDelegatedComponentSeff(ProvidedDelegationConnector connector, Signature signature) {
        OperationProvidedRole role = connector.getInnerProvidedRole_ProvidedDelegationConnector();
        return this.getSeffFromProvidedRole((ProvidedRole)role, signature);
    }

    @Override
    public Optional<ServiceEffectSpecification> getSeffFromProvidedRole(ProvidedRole role, Signature signature) {
        LOGGER.info((Object)("Find SEFF: " + role.getEntityName() + " (ProvidedRole) and " + signature.getEntityName() + " (Signature)"));
        LOGGER.debug((Object)("Number of assembly contexts: " + this.systemModel.getAssemblyContexts__ComposedStructure().size()));
        return this.systemModel.getAssemblyContexts__ComposedStructure().stream().map(AssemblyContext::getEncapsulatedComponent__AssemblyContext).peek(component -> LOGGER.debug((Object)("Encapsulated Component: " + component.getEntityName()))).filter(component -> component.getProvidedRoles_InterfaceProvidingEntity().stream().anyMatch(providedRole2 -> providedRole2.getId().equals(role.getId()))).peek(component -> LOGGER.info((Object)("Found the component: " + component.getEntityName()))).filter(BasicComponent.class::isInstance).map(BasicComponent.class::cast).peek(component -> LOGGER.info((Object)("Found the basic component: " + component.getEntityName()))).map(basicComponent -> this.getSeffFromBasicComponent((BasicComponent)basicComponent, signature)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public Optional<AssemblyContext> findAssemblyContextByProvidedRole(ProvidedRole role) {
        LOGGER.debug((Object)("findAssemblyContextByProvidedRole: ProvidedRole[id=" + role.getId() + "]"));
        return this.systemModel.getAssemblyContexts__ComposedStructure().stream().filter(context -> this.isProvidedRoleInComponent(context.getEncapsulatedComponent__AssemblyContext(), role)).findFirst();
    }

    private boolean isProvidedRoleInComponent(RepositoryComponent component, ProvidedRole role) {
        return component.getProvidedRoles_InterfaceProvidingEntity().stream().anyMatch(providedRole2 -> providedRole2.getId().equals(role.getId()));
    }

    @Override
    public Optional<AssemblyContext> findAssemblyContextByRole(Role role) {
        Optional<AssemblyContext> result;
        if (role instanceof ProvidedRole) {
            result = this.findAssemblyContextByProvidedRole((ProvidedRole)role);
        } else if (role instanceof RequiredRole) {
            result = this.findAssemblyContextFromRequiredRole((RequiredRole)role);
        } else {
            throw new IllegalArgumentException("The role must be either a ProvidedRole or a RequiredRole.");
        }
        return result;
    }

    public Optional<ServiceEffectSpecification> getSeffFromBasicComponent(BasicComponent basicComponent, Signature signature) {
        LOGGER.info((Object)("Start searching for seff: " + basicComponent.getEntityName()));
        return basicComponent.getServiceEffectSpecifications__BasicComponent().stream().filter(spec -> spec.getDescribedService__SEFF().getId().equals(signature.getId())).findFirst();
    }
}

