/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation;

import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.ResourceDemandRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.SEFFInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.ForkBehaviorContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.InfrastructureCallsContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.SeffBehaviorContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.CallOverWireRequested;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.PassiveResourceAcquired;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFChildInterpretationStarted;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFInterpretationFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFInterpretationProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFInterpreted;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.interpreters.SeffInterpreter;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.User;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.UserRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.UserInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserRequestFinished;
import org.palladiosimulator.analyzer.slingshot.common.events.AbstractSimulationEvent;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;

@OnEvent.OnEvents(value={@OnEvent(when=SEFFInterpretationProgressed.class, then={SEFFInterpreted.class}, cardinality=EventCardinality.MANY), @OnEvent(when=SEFFInterpretationFinished.class, then={SEFFInterpretationProgressed.class, UserRequestFinished.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=SEFFChildInterpretationStarted.class, then={SEFFInterpreted.class}, cardinality=EventCardinality.MANY), @OnEvent(when=PassiveResourceAcquired.class, then={SEFFInterpreted.class}, cardinality=EventCardinality.MANY)})
public class SeffSimulationBehavior
implements SimulationBehaviorExtension {
    private static final Logger LOGGER = Logger.getLogger(SeffSimulationBehavior.class);

    @Subscribe
    public Result<SEFFInterpreted> onSeffInterpretationProgressed(SEFFInterpretationProgressed progressed) {
        SeffInterpreter interpreter = new SeffInterpreter((SEFFInterpretationContext)progressed.getEntity());
        SeffBehaviorContextHolder contextHolder = ((SEFFInterpretationContext)progressed.getEntity()).getBehaviorContext();
        if (contextHolder instanceof InfrastructureCallsContextHolder && contextHolder.hasFinished()) {
            LOGGER.info((Object)"progression to parent of infra");
            return Result.of((Object[])new SEFFInterpreted[]{this.continueInParent((SEFFInterpretationContext)progressed.getEntity())});
        }
        Set events = (Set)interpreter.doSwitch((EObject)contextHolder.getNextAction());
        return Result.of((Collection)events);
    }

    @Subscribe
    public Result<SEFFInterpreted> onPassiveResourceAcquired(PassiveResourceAcquired passiveResourceAcquired) {
        SeffInterpreter interpreter = new SeffInterpreter(((ResourceDemandRequest)passiveResourceAcquired.getEntity()).getSeffInterpretationContext());
        Set events = (Set)interpreter.doSwitch((EObject)((ResourceDemandRequest)passiveResourceAcquired.getEntity()).getSeffInterpretationContext().getBehaviorContext().getNextAction());
        return Result.of((Collection)events);
    }

    @Subscribe
    public Result<SEFFInterpreted> onSEFFChildInterpretationStarted(SEFFChildInterpretationStarted seffChildInterpretationStarted) {
        SeffInterpreter interpreter = new SeffInterpreter((SEFFInterpretationContext)seffChildInterpretationStarted.getEntity());
        Set events = (Set)interpreter.doSwitch((EObject)((SEFFInterpretationContext)seffChildInterpretationStarted.getEntity()).getBehaviorContext().getNextAction());
        return Result.of((Collection)events);
    }

    @Subscribe
    public Result<AbstractSimulationEvent> onSEFFInterpretationFinished(SEFFInterpretationFinished finished) {
        Result result;
        SEFFInterpretationContext entity = (SEFFInterpretationContext)finished.getEntity();
        if (entity.getBehaviorContext() instanceof ForkBehaviorContextHolder) {
            ForkBehaviorContextHolder fb = (ForkBehaviorContextHolder)entity.getBehaviorContext();
            if (!entity.getBehaviorContext().hasFinished()) {
                LOGGER.info((Object)"A forked behavior has finished, but not all");
                result = Result.of((Object[])new AbstractSimulationEvent[0]);
            } else if (fb.isProcessed()) {
                result = Result.of((Object[])new AbstractSimulationEvent[0]);
            } else {
                LOGGER.info((Object)"return to parent - from forked");
                fb.markProcessed();
                result = Result.of((Object[])new AbstractSimulationEvent[]{this.continueInParent(entity)});
            }
        } else if (!entity.getBehaviorContext().hasFinished()) {
            LOGGER.info((Object)"repeat scenario");
            result = Result.of((Object[])new AbstractSimulationEvent[]{this.repeat(entity)});
        } else if (entity.getBehaviorContext().isChild()) {
            LOGGER.info((Object)"return to parent");
            result = Result.of((Object[])new AbstractSimulationEvent[]{this.continueInParent(entity)});
        } else if (entity.getCaller().isPresent()) {
            LOGGER.info((Object)"return to caller");
            result = Result.of((Object[])new AbstractSimulationEvent[]{this.continueInCaller(entity)});
        } else {
            LOGGER.info((Object)"finish request");
            result = Result.of((Object[])new AbstractSimulationEvent[]{this.finishUserRequest(entity)});
        }
        return result;
    }

    private UserRequestFinished finishUserRequest(SEFFInterpretationContext entity) {
        UserRequest userRequest = entity.getRequestProcessingContext().getUserRequest();
        UserInterpretationContext userInterpretationContext = entity.getRequestProcessingContext().getUserInterpretationContext().update().withResultFrame(entity.getCurrentResultStackframe()).build();
        this.cleanUpComponentParameterStackFrames(entity.getRequestProcessingContext().getUser());
        return new UserRequestFinished(userRequest, userInterpretationContext);
    }

    private SEFFInterpretationProgressed continueInParent(SEFFInterpretationContext entity) {
        SEFFInterpretationContext seffInterpretationContext = (SEFFInterpretationContext)entity.getParent().orElseThrow(() -> new IllegalStateException("Every child context must have a parent"));
        return new SEFFInterpretationProgressed(seffInterpretationContext);
    }

    private AbstractSimulationEvent continueInCaller(SEFFInterpretationContext entity) {
        this.cleanUpComponentParameterStackFrames(entity.getRequestProcessingContext().getUser());
        return entity.getCallOverWireRequest().map(cowReq -> cowReq.createReplyRequest(entity.getCurrentResultStackframe())).map(CallOverWireRequested::new).map(AbstractSimulationEvent.class::cast).orElseGet(() -> {
            LOGGER.info((Object)"It seems that the call was not over a wire, so proceed with normal progression");
            return new SEFFInterpretationProgressed((SEFFInterpretationContext)entity.getCaller().get());
        });
    }

    private void cleanUpComponentParameterStackFrames(User user) {
        SimulatedStack stack = user.getStack();
        stack.removeStackFrame();
        stack.removeStackFrame();
    }

    private SEFFInterpretationProgressed repeat(SEFFInterpretationContext entity) {
        return new SEFFInterpretationProgressed(entity);
    }
}

