/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation;

import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.GeneralEntryRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.RepositoryInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.CallOverWireRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.ResourceDemandRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.SEFFInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.InfrastructureCallsContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.seff.behaviorcontext.SeffBehaviorContextHolder;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.ActiveResourceFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.CallOverWireAborted;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.CallOverWireRequested;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.CallOverWireSucceeded;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.RepositoryInterpretationInitiated;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.ResourceDemandRequestAborted;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFExternalActionCalled;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFInfrastructureCalled;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.SEFFInterpretationProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.interpreters.RepositoryInterpreter;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.repository.SystemModelRepository;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.UserRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.UserInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserAborted;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserEntryRequested;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.common.utils.SimulatedStackHelper;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;

@OnEvent.OnEvents(value={@OnEvent(when=UserEntryRequested.class, then={SEFFInterpretationProgressed.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=RepositoryInterpretationInitiated.class, then={SEFFInterpretationProgressed.class}, cardinality=EventCardinality.MANY), @OnEvent(when=SEFFExternalActionCalled.class, then={CallOverWireRequested.class}, cardinality=EventCardinality.MANY), @OnEvent(when=CallOverWireSucceeded.class, then={SEFFInterpretationProgressed.class, UserAborted.class}, cardinality=EventCardinality.MANY), @OnEvent(when=CallOverWireAborted.class, then={CallOverWireRequested.class}, cardinality=EventCardinality.MANY), @OnEvent(when=ActiveResourceFinished.class, then={SEFFInterpretationProgressed.class}, cardinality=EventCardinality.MANY), @OnEvent(when=SEFFInfrastructureCalled.class, then={SEFFInterpretationProgressed.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=ResourceDemandRequestAborted.class, then={UserAborted.class}, cardinality=EventCardinality.SINGLE)})
public class SystemSimulationBehavior
implements SimulationBehaviorExtension {
    private static final Logger LOGGER = Logger.getLogger(SystemSimulationBehavior.class);
    private final Allocation allocationModel;
    private final SystemModelRepository systemRepository;

    @Inject
    public SystemSimulationBehavior(Allocation allocationModel, SystemModelRepository repository) {
        this.allocationModel = allocationModel;
        this.systemRepository = repository;
        this.init();
    }

    public void init() {
        this.systemRepository.load(this.allocationModel.getSystem_Allocation());
    }

    @Subscribe
    public Result<SEFFInterpretationProgressed> onUserEntryRequested(UserEntryRequested userEntryRequested) {
        UserRequest request = (UserRequest)userEntryRequested.getEntity();
        OperationProvidedRole operationProvidedRole = request.getOperationProvidedRole();
        OperationSignature operationSignature = request.getOperationSignature();
        EList variableUsages = request.getVariableUsages();
        Optional<ProvidedDelegationConnector> connectedProvidedDelegationConnector = this.systemRepository.getConnectedProvidedDelegationConnector((ProvidedRole)operationProvidedRole);
        if (connectedProvidedDelegationConnector.isEmpty()) {
            LOGGER.info((Object)("This is not an entry request! Role" + operationProvidedRole.getEntityName()));
            return Result.of((Object[])new SEFFInterpretationProgressed[0]);
        }
        Optional<ServiceEffectSpecification> seffFromProvidedRole = this.systemRepository.getDelegatedComponentSeff(connectedProvidedDelegationConnector.get(), (Signature)operationSignature);
        Optional<AssemblyContext> assemblyContextByProvidedRole = this.systemRepository.findAssemblyContextByProvidedRole((ProvidedRole)connectedProvidedDelegationConnector.get().getInnerProvidedRole_ProvidedDelegationConnector());
        LOGGER.debug((Object)("SEFF? " + seffFromProvidedRole.isPresent() + " | AssemblyContext? " + assemblyContextByProvidedRole.isPresent()));
        if (seffFromProvidedRole.isPresent() && assemblyContextByProvidedRole.isPresent()) {
            SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack)request.getUser().getStack(), (EList)variableUsages);
            ServiceEffectSpecification seff = seffFromProvidedRole.get();
            assert (seff instanceof ResourceDemandingBehaviour);
            RepositoryInterpreter interpreter = new RepositoryInterpreter(assemblyContextByProvidedRole.get(), (Signature)operationSignature, (ProvidedRole)operationProvidedRole, request.getUser(), this.systemRepository, Optional.empty(), null, (SimulatedStackframe<Object>)new SimulatedStackframe(), userEntryRequested.getUserInterpretationContext(), request);
            Set res = (Set)interpreter.doSwitch((EObject)assemblyContextByProvidedRole.get().getEncapsulatedComponent__AssemblyContext());
            return Result.of((Collection)res);
        }
        LOGGER.info((Object)"Either seff or assembly context is not found => stop interpretation for this request.");
        return Result.of((Object[])new SEFFInterpretationProgressed[0]);
    }

    @Subscribe
    public Result<SEFFInterpretationProgressed> onRepositoryInterpretationInitiated(RepositoryInterpretationInitiated event) {
        RepositoryInterpretationContext context = (RepositoryInterpretationContext)event.getEntity();
        RepositoryInterpreter interpreter = new RepositoryInterpreter(context.getAssemblyContext(), context.getSignature(), context.getProvidedRole(), context.getUser(), this.systemRepository, Optional.empty(), null, null);
        Set appearedEvents = (Set)interpreter.doSwitch((EObject)context.getProvidedRole());
        return Result.of((Collection)appearedEvents);
    }

    @Subscribe
    public Result<?> onRequestInitiated(SEFFExternalActionCalled requestInitiated) {
        return this.requestCallOverWire((GeneralEntryRequest)requestInitiated.getEntity());
    }

    private Result<?> requestCallOverWire(GeneralEntryRequest entity) {
        Optional<AssemblyContext> assemblyContext = this.systemRepository.findAssemblyContextFromRequiredRole(entity.getRequiredRole());
        Optional<OperationProvidedRole> providedRole = this.systemRepository.findProvidedRoleFromRequiredRole(entity.getRequiredRole());
        if (assemblyContext.isPresent() && providedRole.isPresent()) {
            SimulatedStackframe inputStackframe = SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack)entity.getUser().getStack(), (EList)entity.getInputVariableUsages());
            CallOverWireRequest request = CallOverWireRequest.builder().from(entity.getRequestFrom().getAssemblyContext()).to(assemblyContext.get()).signature(entity.getSignature()).user(entity.getUser()).entryRequest(entity).variablesToConsider(inputStackframe).build();
            return Result.of((Object[])new CallOverWireRequested[]{new CallOverWireRequested(request)});
        }
        return Result.of((Object[])new Object[0]);
    }

    @Subscribe
    public Result<?> onCallOverWireSucceeded(CallOverWireSucceeded cowSucceeded) {
        GeneralEntryRequest entity = cowSucceeded.getRequest().getEntryRequest();
        if (cowSucceeded.getRequest().getReplyTo().isPresent()) {
            SEFFInterpretationContext seffInterpretationContext = entity.getRequestFrom();
            entity.getUser().getStack().removeStackFrame();
            SimulatedStackHelper.addParameterToStackFrame((SimulatedStackframe)cowSucceeded.getRequest().getVariablesToConsider(), (EList)entity.getOutputVariableUsages(), (SimulatedStackframe)entity.getUser().getStack().currentStackFrame());
            return Result.of((Object[])new SEFFInterpretationProgressed[]{new SEFFInterpretationProgressed(seffInterpretationContext)});
        }
        Optional<AssemblyContext> assemblyContext = this.systemRepository.findAssemblyContextFromRequiredRole(entity.getRequiredRole());
        Optional<OperationProvidedRole> providedRole = this.systemRepository.findProvidedRoleFromRequiredRole(entity.getRequiredRole());
        if (assemblyContext.isPresent() && providedRole.isPresent()) {
            RepositoryInterpreter interpreter = new RepositoryInterpreter(assemblyContext.get(), entity.getSignature(), (ProvidedRole)providedRole.get(), entity.getUser(), this.systemRepository, Optional.of(entity.getRequestFrom()), cowSucceeded.getRequest(), (SimulatedStackframe<Object>)new SimulatedStackframe());
            Set appearedEvents = (Set)interpreter.doSwitch((EObject)assemblyContext.get().getEncapsulatedComponent__AssemblyContext());
            return Result.of((Collection)appearedEvents);
        }
        LOGGER.debug((Object)String.format("Could not continue after %s to %s. BEWARE : untested edge case!!!", CallOverWireSucceeded.class.getSimpleName(), entity.getRequiredRole().toString()));
        return Result.of((Object[])new UserAborted[]{new UserAborted(cowSucceeded.getRequest().getEntryRequest().getRequestFrom().getRequestProcessingContext().getUserInterpretationContext())});
    }

    @Subscribe
    public Result<?> onCallOverWireAborted(CallOverWireAborted cowAborted) {
        LOGGER.info((Object)"The call over wire was aborted, retry");
        cowAborted.getRequest().getUser().getStack().removeStackFrame();
        return this.requestCallOverWire(cowAborted.getRequest().getEntryRequest());
    }

    @Subscribe
    public Result<UserAborted> onResourceDemandRequestAborted(ResourceDemandRequestAborted demandRequestAborted) {
        return Result.of((Object[])new UserAborted[]{new UserAborted(this.findUserInterpretationContext(((ResourceDemandRequest)demandRequestAborted.getEntity()).getSeffInterpretationContext()))});
    }

    private UserInterpretationContext findUserInterpretationContext(SEFFInterpretationContext seffContext) throws NoSuchElementException {
        if (seffContext.getRequestProcessingContext().getUserInterpretationContext() != null) {
            return seffContext.getRequestProcessingContext().getUserInterpretationContext();
        }
        if (seffContext.getCaller().isPresent()) {
            return this.findUserInterpretationContext((SEFFInterpretationContext)seffContext.getCaller().get());
        }
        if (seffContext.getParent().isPresent()) {
            return this.findUserInterpretationContext((SEFFInterpretationContext)seffContext.getParent().get());
        }
        throw new NoSuchElementException("User Interpretation Context not found!");
    }

    @Subscribe
    public Result<SEFFInterpretationProgressed> onSEFFInfrastructureCalled(SEFFInfrastructureCalled infraCall) {
        GeneralEntryRequest entity = (GeneralEntryRequest)infraCall.getEntity();
        Optional<AssemblyContext> assemblyContext = this.systemRepository.findInfrastructureAssemblyContextFromRequiredRole(entity.getRequiredRole());
        if (assemblyContext.isPresent()) {
            RepositoryInterpreter interpreter = new RepositoryInterpreter(assemblyContext.get(), entity.getSignature(), null, entity.getUser(), this.systemRepository, Optional.of(entity.getRequestFrom()), null, null);
            Set appearedEvents = (Set)interpreter.doSwitch((EObject)assemblyContext.get().getEncapsulatedComponent__AssemblyContext());
            return Result.of((Collection)appearedEvents);
        }
        return Result.of((Object[])new SEFFInterpretationProgressed[0]);
    }

    @Subscribe
    public Result<DESEvent> onActiveResourceFinished(ActiveResourceFinished activeResourceFinished) {
        SEFFInterpretationContext parentContext = ((ResourceDemandRequest)activeResourceFinished.getEntity()).getSeffInterpretationContext();
        AbstractAction parentalAction = parentContext.getBehaviorContext().getCurrentProcessedBehavior().getCurrentAction().getPredecessor_AbstractAction();
        if (!(parentalAction instanceof InternalAction) || ((InternalAction)parentalAction).getInfrastructureCall__Action().isEmpty()) {
            return Result.of((Object[])new DESEvent[]{new SEFFInterpretationProgressed(((ResourceDemandRequest)activeResourceFinished.getEntity()).getSeffInterpretationContext())});
        }
        InfrastructureCallsContextHolder infraContext = new InfrastructureCallsContextHolder(((ResourceDemandRequest)activeResourceFinished.getEntity()).getSeffInterpretationContext(), (InternalAction)parentalAction, ((ResourceDemandRequest)activeResourceFinished.getEntity()).getSeffInterpretationContext().getBehaviorContext().getCurrentProcessedBehavior());
        SEFFInterpretationContext infraChildContext = SEFFInterpretationContext.builder().withBehaviorContext((SeffBehaviorContextHolder)infraContext).withRequestProcessingContext(parentContext.getRequestProcessingContext()).withCaller(parentContext.getCaller()).withAssemblyContext(parentContext.getAssemblyContext()).build();
        return Result.of((Object[])new DESEvent[]{new SEFFInterpretationProgressed(infraChildContext)});
    }
}

