/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usageevolution.evolver;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.Workload;
import org.scaledl.usageevolution.Usage;
import org.scaledl.usageevolution.WorkParameterEvolution;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.generator.ModelEvaluator;

public abstract class AbstractUsageEvolver {
    static final Logger LOGGER = Logger.getLogger(AbstractUsageEvolver.class);
    private final Optional<ModelEvaluator> loadEvaluator;
    private final Map<VariableCharacterisation, ModelEvaluator> workEvaluators = new HashMap<VariableCharacterisation, ModelEvaluator>();
    private final Usage usage;

    public AbstractUsageEvolver(Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException("Usage is null, but must not be.");
        }
        this.usage = usage;
        Sequence loadEvolutionSequence = usage.getLoadEvolution();
        this.loadEvaluator = loadEvolutionSequence != null ? Optional.of(new ModelEvaluator(loadEvolutionSequence)) : Optional.empty();
        this.initWorkEvaluators();
    }

    protected void initWorkEvaluators() {
        if (this.usage.getWorkEvolutions() != null) {
            for (WorkParameterEvolution workParam : this.usage.getWorkEvolutions()) {
                VariableCharacterisation varChar = workParam.getVariableCharacterisation();
                Sequence paramSequence = workParam.getEvolution();
                if (varChar == null) {
                    LOGGER.error((Object)"Skipping evolution of unspecified work parameter");
                    continue;
                }
                if (paramSequence == null) {
                    LOGGER.error((Object)("Skipping unspecified evolution for work parameter " + varChar));
                    continue;
                }
                this.workEvaluators.put(varChar, new ModelEvaluator(paramSequence));
            }
        }
    }

    public void triggerInternal(double time) {
        this.loadEvaluator.ifPresent(evaluator -> this.evolveLoad((ModelEvaluator)evaluator, time));
        for (VariableCharacterisation workParam : this.workEvaluators.keySet()) {
            this.evolveWork(workParam, this.workEvaluators.get(workParam), time);
        }
    }

    protected double getDLIMFinalDuration() {
        return this.usage.getLoadEvolution().getFinalDuration();
    }

    protected void evolveLoad(ModelEvaluator loadEvaluator, double time) {
        double newRate = this.getNewRate(loadEvaluator, time);
        Workload wl = this.usage.getScenario().getWorkload_UsageScenario();
        if (wl != null) {
            if (wl instanceof OpenWorkload) {
                String interArrivalTimeNewSpec;
                double interArrivalTime = 2.147483647E9;
                PCMRandomVariable openwl = ((OpenWorkload)wl).getInterArrivalTime_OpenWorkload();
                if (newRate != 0.0) {
                    interArrivalTime = 1.0 / newRate;
                }
                if ((interArrivalTimeNewSpec = Double.toString(interArrivalTime)).equals(openwl.getSpecification())) {
                    LOGGER.debug((Object)String.format("Inter arrival time in %s is still: %s", this.usage.getEntityName(), interArrivalTimeNewSpec));
                } else {
                    LOGGER.debug((Object)String.format("Changing inter arrival time in %s from: %s to : %s", this.usage.getEntityName(), openwl.getSpecification(), interArrivalTimeNewSpec));
                    openwl.setSpecification(interArrivalTimeNewSpec);
                }
            } else if (wl instanceof ClosedWorkload) {
                int oldRate;
                int newRateInt = (int)Math.round(newRate);
                if (newRateInt == (oldRate = ((ClosedWorkload)wl).getPopulation())) {
                    LOGGER.debug((Object)String.format("Closed workload population in %s is still: %d ", this.usage.getEntityName(), newRateInt));
                } else {
                    LOGGER.debug((Object)String.format("Changing closed workload population in %s from: %d to %d.", this.usage.getEntityName(), oldRate, newRateInt));
                    ((ClosedWorkload)wl).setPopulation(newRateInt);
                }
            }
        }
    }

    protected abstract double getNewRate(ModelEvaluator var1, double var2);

    protected void evolveWork(VariableCharacterisation workParameter, ModelEvaluator evaluator, double time) {
        if (evaluator == null) {
            return;
        }
        long newRate = Math.round(this.getNewRate(evaluator, time));
        String newRateStr = Long.toString(newRate);
        LOGGER.debug((Object)("Changing work from " + workParameter.getSpecification_VariableCharacterisation().getSpecification() + " to " + newRateStr));
        workParameter.getSpecification_VariableCharacterisation().setSpecification(newRateStr);
    }
}

