/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usageevolution.evolver;

import java.util.Optional;
import org.palladiosimulator.analyzer.slingshot.behavior.usageevolution.evolver.AbstractUsageEvolver;
import org.scaledl.usageevolution.Usage;
import tools.descartes.dlim.generator.ModelEvaluator;

public class StretchedUsageEvolver
extends AbstractUsageEvolver {
    private final double timeFactor;
    private static final double DELTA = 1.0E-6;

    public StretchedUsageEvolver(Usage usage, Optional<Double> maxSimTime) {
        super(usage);
        if (maxSimTime.isEmpty()) {
            throw new IllegalArgumentException("Initializing a streched usage evolver requires a specified maximum simulation time");
        }
        this.timeFactor = maxSimTime.get() / this.getDLIMFinalDuration();
    }

    @Override
    protected double getNewRate(ModelEvaluator loadEvaluator, double time) {
        double evaluationTime = time / this.timeFactor;
        if (evaluationTime >= this.getDLIMFinalDuration() - 1.0E-6) {
            return loadEvaluator.getArrivalRateAtTime(evaluationTime - 1.0E-6);
        }
        return loadEvaluator.getArrivalRateAtTime(time / this.timeFactor);
    }
}

