/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities;

import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.User;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;

public final class UserRequest {
    private final User user;
    private final OperationProvidedRole operationProvidedRole;
    private final OperationSignature operationSignature;
    private final EList<VariableUsage> variableUsages;
    private final EList<VariableUsage> outVariableUsages;

    private UserRequest(Builder builder) {
        this.user = builder.user;
        this.operationProvidedRole = builder.operationProvidedRole;
        this.operationSignature = builder.operationSignature;
        this.variableUsages = builder.variableUsages;
        this.outVariableUsages = builder.outVariableUsages;
    }

    public User getUser() {
        return this.user;
    }

    public OperationProvidedRole getOperationProvidedRole() {
        return this.operationProvidedRole;
    }

    public OperationSignature getOperationSignature() {
        return this.operationSignature;
    }

    public EList<VariableUsage> getVariableUsages() {
        return this.variableUsages;
    }

    public EList<VariableUsage> getOutVariableUsages() {
        return this.outVariableUsages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private User user;
        private OperationProvidedRole operationProvidedRole;
        private OperationSignature operationSignature;
        private EList<VariableUsage> variableUsages;
        private EList<VariableUsage> outVariableUsages;

        private Builder() {
        }

        public Builder withUser(User user) {
            this.user = user;
            return this;
        }

        public Builder withOperationProvidedRole(OperationProvidedRole operationProvidedRole) {
            this.operationProvidedRole = operationProvidedRole;
            return this;
        }

        public Builder withOperationSignature(OperationSignature operationSignature) {
            this.operationSignature = operationSignature;
            return this;
        }

        public Builder withVariableUsages(EList<VariableUsage> variableUsages) {
            this.variableUsages = variableUsages;
            return this;
        }

        public Builder withOutVariableUsages(EList<VariableUsage> outVariableUsages) {
            this.outVariableUsages = outVariableUsages;
            return this;
        }

        public UserRequest build() {
            return new UserRequest(this);
        }
    }
}

