/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior;

import com.google.common.base.Preconditions;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior.UsageScenarioBehaviorContext;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;

public final class LoopScenarioBehaviorContext
extends UsageScenarioBehaviorContext {
    private final int maximalLoopCount;
    private int progression;

    public LoopScenarioBehaviorContext(Builder builder) {
        super(builder);
        Preconditions.checkArgument((boolean)this.getNextAction().isPresent(), (Object)"The next action must be present");
        Preconditions.checkArgument((builder.initialLoopCount < builder.maximalLoopCount && builder.initialLoopCount >= 0 ? 1 : 0) != 0, (Object)String.format("InitialLoopCount must be in [0,%d] (maximalLoopCount) but is %d", builder.maximalLoopCount, builder.initialLoopCount));
        this.maximalLoopCount = builder.maximalLoopCount;
        this.progression = builder.initialLoopCount;
    }

    @Override
    public boolean mustRepeatScenario() {
        return this.progression < this.maximalLoopCount;
    }

    @Override
    public AbstractUserAction startScenario() {
        AbstractUserAction userAction = super.startScenario();
        ++this.progression;
        return userAction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder update() {
        return LoopScenarioBehaviorContext.builder().withInitialLoopCount(this.progression).withMaximalLoopCount(this.maximalLoopCount);
    }

    public static final class Builder
    extends UsageScenarioBehaviorContext.BaseBuilder<LoopScenarioBehaviorContext, Builder> {
        private int maximalLoopCount = -1;
        private int initialLoopCount = 0;

        private Builder() {
        }

        public Builder withMaximalLoopCount(int maximalLoopCount) {
            this.maximalLoopCount = maximalLoopCount;
            return this;
        }

        public Builder withInitialLoopCount(int initialLoopCount) {
            this.initialLoopCount = initialLoopCount;
            return this;
        }

        @Override
        public LoopScenarioBehaviorContext build() {
            return new LoopScenarioBehaviorContext(this);
        }
    }
}

