/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;

public abstract class UsageScenarioBehaviorContext {
    private final Optional<AbstractUserAction> nextAction;
    private final Optional<UsageScenarioBehaviorContext> parent;
    private final ScenarioBehaviour scenarioBehavior;

    UsageScenarioBehaviorContext(BaseBuilder<?, ?> builder) {
        Preconditions.checkArgument((builder.nextAction != null && builder.parent != null && builder.scenarioBehavior != null ? 1 : 0) != 0);
        Preconditions.checkArgument((builder.nextAction.isEmpty() || builder.parent.isPresent() ? 1 : 0) != 0);
        this.nextAction = builder.nextAction;
        this.parent = builder.parent;
        this.scenarioBehavior = builder.scenarioBehavior;
    }

    public abstract boolean mustRepeatScenario();

    public Optional<AbstractUserAction> getNextAction() {
        return this.nextAction;
    }

    public Optional<UsageScenarioBehaviorContext> getParent() {
        return this.parent;
    }

    public boolean isChildContext() {
        return this.parent.isPresent();
    }

    public boolean isRootContext() {
        return this.parent.isEmpty();
    }

    public AbstractUserAction startScenario() {
        if (!this.mustRepeatScenario()) {
            throw new IllegalStateException("This scenario cannot be repeated again");
        }
        return this.scenarioBehavior.getActions_ScenarioBehaviour().stream().filter(Start.class::isInstance).findFirst().orElseThrow(() -> new IllegalStateException("The model must have a Start action in order to perform"));
    }

    public ScenarioBehaviour getScenarioBehavior() {
        return this.scenarioBehavior;
    }

    public static abstract class BaseBuilder<T extends UsageScenarioBehaviorContext, B extends BaseBuilder<T, B>> {
        private Optional<AbstractUserAction> nextAction = Optional.empty();
        private Optional<UsageScenarioBehaviorContext> parent = Optional.empty();
        private ScenarioBehaviour scenarioBehavior;

        protected BaseBuilder() {
        }

        public B withNextAction(Optional<AbstractUserAction> nextAction) {
            this.nextAction = nextAction;
            return (B)this;
        }

        public B withParent(Optional<UsageScenarioBehaviorContext> parent) {
            this.parent = parent;
            return (B)this;
        }

        public B withScenarioBehavior(ScenarioBehaviour scenarioBehavior) {
            this.scenarioBehavior = scenarioBehavior;
            return (B)this;
        }

        public abstract T build();
    }
}

