/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext;

import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.User;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior.UsageScenarioBehaviorContext;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public abstract class UserInterpretationContext {
    private final UsageScenario scenario;
    private final AbstractUserAction currentAction;
    private final User user;
    private final int currentUsageRun;
    private final UsageScenarioBehaviorContext behaviorContext;
    private final SimulatedStackframe<Object> resultFrame;

    protected UserInterpretationContext(BaseBuilder<?, ?> builder) {
        this.scenario = builder.scenario;
        this.currentAction = builder.currentAction;
        this.user = builder.user;
        this.currentUsageRun = builder.currentUsageRun;
        this.behaviorContext = builder.usageScenarioBehaviorContext;
        this.resultFrame = builder.resultFrame;
    }

    public SimulatedStackframe<Object> getResultFrame() {
        return this.resultFrame;
    }

    public UsageScenario getScenario() {
        return this.scenario;
    }

    public AbstractUserAction getCurrentAction() {
        return this.currentAction;
    }

    public User getUser() {
        return this.user;
    }

    public int getCurrentUsageRun() {
        return this.currentUsageRun;
    }

    public UserInterpretationContext incrementUsageRun() {
        return ((BaseBuilder)((BaseBuilder)this.update()).withCurrentUsageRun(this.currentUsageRun + 1)).build();
    }

    public UserInterpretationContext updateAction(AbstractUserAction abstractAction) {
        return ((BaseBuilder)((BaseBuilder)this.update()).withCurrentAction(abstractAction)).build();
    }

    public abstract <T extends UserInterpretationContext, B extends BaseBuilder<T, B>> B update();

    protected final <T extends UserInterpretationContext, B extends BaseBuilder<T, B>> B updateWithBuilder(B builder) {
        return ((BaseBuilder)((BaseBuilder)((BaseBuilder)((BaseBuilder)builder.withCurrentAction(this.currentAction)).withCurrentUsageRun(this.currentUsageRun)).withScenario(this.scenario)).withUser(this.user)).withUsageScenarioBehaviorContext(this.getBehaviorContext());
    }

    public UsageScenarioBehaviorContext getBehaviorContext() {
        return this.behaviorContext;
    }

    protected static abstract class BaseBuilder<T extends UserInterpretationContext, B extends BaseBuilder<T, B>> {
        private UsageScenario scenario;
        private AbstractUserAction currentAction;
        private User user;
        private int currentUsageRun;
        private UsageScenarioBehaviorContext usageScenarioBehaviorContext;
        private SimulatedStackframe<Object> resultFrame;

        protected BaseBuilder() {
        }

        public B withResultFrame(SimulatedStackframe<Object> resultFrame) {
            this.resultFrame = resultFrame;
            return this.actualBuilder();
        }

        public B withScenario(UsageScenario scenario) {
            this.scenario = scenario;
            return this.actualBuilder();
        }

        public B withCurrentAction(AbstractUserAction currentAction) {
            this.currentAction = currentAction;
            return this.actualBuilder();
        }

        public B withUser(User user) {
            this.user = user;
            return this.actualBuilder();
        }

        public B withCurrentUsageRun(int currentUsageRun) {
            this.currentUsageRun = currentUsageRun;
            return this.actualBuilder();
        }

        public B withUsageScenarioBehaviorContext(UsageScenarioBehaviorContext usageScenarioBehaviorContext) {
            this.usageScenarioBehaviorContext = usageScenarioBehaviorContext;
            return this.actualBuilder();
        }

        protected B actualBuilder() {
            return (B)this;
        }

        public abstract T build();
    }
}

