/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usagesimulation.monitor;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior.RootScenarioContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UsageModelPassedElement;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.analyzer.slingshot.monitor.data.entities.ProbeTakenEntity;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.CalculatorRegistered;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.ProbeTaken;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MeasurementSpecificationVisited;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MonitorModelVisited;
import org.palladiosimulator.analyzer.slingshot.monitor.utils.probes.EventCurrentSimulationTimeProbe;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcmmeasuringpoint.UsageScenarioReference;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.Probe;

@OnEvent.OnEvents(value={@OnEvent(when=MonitorModelVisited.class, then={CalculatorRegistered.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=UsageModelPassedElement.class, then={ProbeTaken.class}, cardinality=EventCardinality.SINGLE)})
public class UsageScenarioResponseTimeMonitoringBehavior
implements SimulationBehaviorExtension {
    private final IGenericCalculatorFactory calculatorFactory;
    private final Map<String, UserProbes> userProbesMap = new HashMap<String, UserProbes>();

    @Inject
    public UsageScenarioResponseTimeMonitoringBehavior(IGenericCalculatorFactory calculatorFactory) {
        this.calculatorFactory = calculatorFactory;
    }

    @Subscribe
    public Result<CalculatorRegistered> onMeasurementSpecificationVisited(MeasurementSpecificationVisited event) {
        MeasurementSpecification measurementSpecification = (MeasurementSpecification)event.getEntity();
        MeasuringPoint measuringPoint = measurementSpecification.getMonitor().getMeasuringPoint();
        if (measuringPoint instanceof UsageScenarioReference && MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)measurementSpecification.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC)) {
            UsageScenario scenario = ((UsageScenarioReference)measuringPoint).getUsageScenario();
            UserProbes userProbes = new UserProbes();
            this.userProbesMap.put(scenario.getId(), userProbes);
            Calculator calculator = this.calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createStartStopProbeConfiguration((Probe)userProbes.userStartedProbe, (Probe)userProbes.userStoppedProbe));
            return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered(calculator)});
        }
        return Result.empty();
    }

    @Subscribe(reified={Start.class})
    public Result<ProbeTaken> onUsageScenarioStarted(UsageModelPassedElement<Start> userStarted) {
        if (userStarted.getContext().getBehaviorContext() instanceof RootScenarioContext && this.userProbesMap.containsKey(userStarted.getContext().getScenario().getId())) {
            UserProbes userProbes = this.userProbesMap.get(userStarted.getContext().getScenario().getId());
            userProbes.userStartedProbe.takeMeasurement(userStarted);
            return Result.of((Object[])new ProbeTaken[]{new ProbeTaken(ProbeTakenEntity.builder().withProbe((Probe)userProbes.userStartedProbe).build())});
        }
        return Result.empty();
    }

    @Subscribe(reified={Stop.class})
    public Result<ProbeTaken> onUsageScenarioFinished(UsageModelPassedElement<Stop> userStopped) {
        if (userStopped.getContext().getBehaviorContext() instanceof RootScenarioContext && this.userProbesMap.containsKey(userStopped.getContext().getScenario().getId())) {
            UserProbes userProbes = this.userProbesMap.get(userStopped.getContext().getScenario().getId());
            userProbes.userStoppedProbe.takeMeasurement(userStopped);
            return Result.of((Object[])new ProbeTaken[]{new ProbeTaken(ProbeTakenEntity.builder().withProbe((Probe)userProbes.userStoppedProbe).build())});
        }
        return Result.empty();
    }

    private static final class UserProbes {
        private final EventCurrentSimulationTimeProbe userStartedProbe = new EventCurrentSimulationTimeProbe(UserProbes::passedElement);
        private final EventCurrentSimulationTimeProbe userStoppedProbe = new EventCurrentSimulationTimeProbe(UserProbes::passedElement);

        private UserProbes() {
        }

        private static RequestContext passedElement(DESEvent event) {
            if (event instanceof UsageModelPassedElement) {
                UsageModelPassedElement el = (UsageModelPassedElement)event;
                return new RequestContext(el.getContext().getUser().getId());
            }
            return RequestContext.EMPTY_REQUEST_CONTEXT;
        }
    }
}

