/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usagesimulation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.InterArrivalTime;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.ThinkTime;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.User;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.UserRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.ClosedWorkloadUserInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.OpenWorkloadUserInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.UsageInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.UsageScenarioInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.UserInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior.RootScenarioContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior.UsageScenarioBehaviorContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.ClosedWorkloadUserInitiated;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.InnerScenarioBehaviorInitiated;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.InterArrivalUserInitiated;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UsageModelPassedElement;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UsageScenarioFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UsageScenarioStarted;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserAborted;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserEntryRequested;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserInterpretationProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserRequestFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserSlept;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserStarted;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserWokeUp;
import org.palladiosimulator.analyzer.slingshot.behavior.usagesimulation.interpreters.UsageScenarioInterpreter;
import org.palladiosimulator.analyzer.slingshot.behavior.usagesimulation.repositories.UsageModelRepository;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.common.utils.SimulatedStackHelper;
import org.palladiosimulator.analyzer.slingshot.core.events.SimulationStarted;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

@OnEvent.OnEvents(value={@OnEvent(when=SimulationStarted.class, then={UserStarted.class, InterArrivalUserInitiated.class, UsageModelPassedElement.class}, cardinality=EventCardinality.MANY), @OnEvent(when=UserStarted.class, then={UserFinished.class, UserEntryRequested.class, UserSlept.class, UserWokeUp.class, InnerScenarioBehaviorInitiated.class, UsageScenarioStarted.class, UsageModelPassedElement.class}, cardinality=EventCardinality.MANY), @OnEvent(when=UserFinished.class, then={UserStarted.class, InterArrivalUserInitiated.class, ClosedWorkloadUserInitiated.class, UsageScenarioFinished.class, UserFinished.class, UserSlept.class, UserWokeUp.class, UsageModelPassedElement.class}, cardinality=EventCardinality.MANY), @OnEvent(when=UserAborted.class, then={UserStarted.class, InterArrivalUserInitiated.class, ClosedWorkloadUserInitiated.class, UsageScenarioFinished.class, UserFinished.class, UserSlept.class, UserWokeUp.class, UsageModelPassedElement.class}, cardinality=EventCardinality.MANY), @OnEvent(when=UserWokeUp.class, then={UserFinished.class, UserEntryRequested.class, UserSlept.class, UserWokeUp.class, InnerScenarioBehaviorInitiated.class, UsageModelPassedElement.class}, cardinality=EventCardinality.MANY), @OnEvent(when=UserRequestFinished.class, then={UserFinished.class, UserEntryRequested.class, UserSlept.class, UserWokeUp.class, InnerScenarioBehaviorInitiated.class, UsageModelPassedElement.class}, cardinality=EventCardinality.MANY), @OnEvent(when=InnerScenarioBehaviorInitiated.class, then={UserInterpretationProgressed.class, UsageModelPassedElement.class}, cardinality=EventCardinality.MANY), @OnEvent(when=ClosedWorkloadUserInitiated.class, then={UserStarted.class, UsageModelPassedElement.class}, cardinality=EventCardinality.MANY), @OnEvent(when=InterArrivalUserInitiated.class, then={UserFinished.class, UserEntryRequested.class, UserSlept.class, UserWokeUp.class, InnerScenarioBehaviorInitiated.class, UsageScenarioStarted.class, UsageModelPassedElement.class}, cardinality=EventCardinality.MANY), @OnEvent(when=UserInterpretationProgressed.class, then={UserEntryRequested.class, UserFinished.class, UserInterpretationProgressed.class}, cardinality=EventCardinality.SINGLE)})
public class UsageSimulationBehavior
implements SimulationBehaviorExtension {
    private final Logger LOGGER = Logger.getLogger(UsageSimulationBehavior.class);
    private UsageInterpretationContext usageInterpretationContext;
    private final UsageModelRepository usageModelRepository;
    private final UsageModel usageModel;

    @Inject
    public UsageSimulationBehavior(UsageModel usageModel, UsageModelRepository repository) {
        this.usageModel = usageModel;
        this.usageModelRepository = repository;
        this.init();
    }

    public void init() {
        this.usageModelRepository.load(this.usageModel);
        this.usageInterpretationContext = UsageInterpretationContext.builder().withUsageScenariosContexts(this.collectAllUsageScenarios()).build();
    }

    private ImmutableList<UsageScenarioInterpretationContext> collectAllUsageScenarios() {
        return this.usageModelRepository.findAllUsageScenarios().stream().map(scenario -> UsageScenarioInterpretationContext.builder().withScenario(scenario).build()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    @Subscribe
    public Result<DESEvent> onSimulationStart(SimulationStarted evt) {
        HashSet<DESEvent> returnedEvents = new HashSet<DESEvent>();
        this.startUsageSimulation(returnedEvents);
        return Result.of(returnedEvents);
    }

    private void startUsageSimulation(Set<DESEvent> returnedEvents) {
        assert (returnedEvents != null);
        for (UsageScenarioInterpretationContext usageScenarioContext : this.usageInterpretationContext.getUsageScenarioContexts()) {
            UsageScenario usageScenario = usageScenarioContext.getScenario();
            AbstractUserAction firstAction = this.usageModelRepository.findFirstActionOf(usageScenario).orElseThrow(() -> new IllegalStateException("There must be a Start user action within the usage scenario."));
            if (usageScenarioContext.isClosedWorkload()) {
                this.interpreteClosedWorkload(returnedEvents, usageScenario, firstAction);
                continue;
            }
            this.interpreteOpenWorkload(returnedEvents, usageScenario, firstAction);
        }
    }

    private void interpreteOpenWorkload(Set<DESEvent> returnedEvents, UsageScenario usageScenario, AbstractUserAction firstAction) {
        assert (usageScenario.getWorkload_UsageScenario() instanceof OpenWorkload);
        OpenWorkload workloadSpec = (OpenWorkload)usageScenario.getWorkload_UsageScenario();
        PCMRandomVariable interArrivalRV = workloadSpec.getInterArrivalTime_OpenWorkload();
        RootScenarioContext scenarioContext = ((RootScenarioContext.Builder)RootScenarioContext.builder().withScenarioBehavior(usageScenario.getScenarioBehaviour_UsageScenario())).build();
        OpenWorkloadUserInterpretationContext openWorkloadUserInterpretationContext = ((OpenWorkloadUserInterpretationContext.Builder)((OpenWorkloadUserInterpretationContext.Builder)((OpenWorkloadUserInterpretationContext.Builder)((OpenWorkloadUserInterpretationContext.Builder)OpenWorkloadUserInterpretationContext.builder().withUser(new User())).withScenario(usageScenario)).withCurrentAction(firstAction)).withInterArrivalTime(new InterArrivalTime(interArrivalRV)).withUsageScenarioBehaviorContext((UsageScenarioBehaviorContext)scenarioContext)).build();
        UsageScenarioInterpreter interpreter = new UsageScenarioInterpreter((UserInterpretationContext)openWorkloadUserInterpretationContext);
        Object events = interpreter.doSwitch((EObject)firstAction);
        returnedEvents.addAll((Collection<DESEvent>)events);
    }

    private void interpreteClosedWorkload(Set<DESEvent> returnedEvents, UsageScenario usageScenario, AbstractUserAction firstAction) {
        assert (usageScenario.getWorkload_UsageScenario() instanceof ClosedWorkload);
        RootScenarioContext scenarioContext = ((RootScenarioContext.Builder)RootScenarioContext.builder().withScenarioBehavior(usageScenario.getScenarioBehaviour_UsageScenario())).build();
        ClosedWorkload workloadSpec = (ClosedWorkload)usageScenario.getWorkload_UsageScenario();
        ClosedWorkloadUserInterpretationContext.Builder partialInterpretationBuilder = (ClosedWorkloadUserInterpretationContext.Builder)((ClosedWorkloadUserInterpretationContext.Builder)((ClosedWorkloadUserInterpretationContext.Builder)ClosedWorkloadUserInterpretationContext.builder().withCurrentAction(firstAction)).withThinkTime(new ThinkTime(workloadSpec.getThinkTime_ClosedWorkload())).withUsageScenarioBehaviorContext((UsageScenarioBehaviorContext)scenarioContext)).withScenario(usageScenario);
        int i = 0;
        while (i < workloadSpec.getPopulation()) {
            ClosedWorkloadUserInterpretationContext interpretationContext = ((ClosedWorkloadUserInterpretationContext.Builder)partialInterpretationBuilder.withUser(new User())).build();
            UsageScenarioInterpreter interpreter = new UsageScenarioInterpreter((UserInterpretationContext)interpretationContext);
            Object events = interpreter.doSwitch((EObject)firstAction);
            returnedEvents.addAll((Collection<DESEvent>)events);
            ++i;
        }
    }

    @Subscribe
    public Result<DESEvent> onUserStarted(UserStarted userStarted) {
        ((UserInterpretationContext)userStarted.getEntity()).getUser().getStack().createAndPushNewStackFrame();
        UsageScenarioInterpreter interpreter = new UsageScenarioInterpreter((UserInterpretationContext)userStarted.getEntity());
        HashSet<UsageScenarioStarted> result = new HashSet<UsageScenarioStarted>((Collection<UsageScenarioStarted>)interpreter.doSwitch((EObject)((UserInterpretationContext)userStarted.getEntity()).getCurrentAction()));
        if (((UserInterpretationContext)userStarted.getEntity()).getBehaviorContext().isRootContext()) {
            result.add(new UsageScenarioStarted((UserInterpretationContext)userStarted.getEntity(), 0.0));
        }
        return Result.of(result);
    }

    @Subscribe
    public Result<DESEvent> onInterArrivalUserInitiated(InterArrivalUserInitiated interArrivalUserInitiated) {
        OpenWorkloadUserInterpretationContext openWorkloadUserInterpretationContext = (OpenWorkloadUserInterpretationContext)interArrivalUserInitiated.getEntity();
        UsageScenarioInterpreter interpreter = new UsageScenarioInterpreter((UserInterpretationContext)openWorkloadUserInterpretationContext);
        AbstractUserAction firstAction = openWorkloadUserInterpretationContext.getCurrentAction();
        Object events = interpreter.doSwitch((EObject)firstAction);
        return Result.of((Collection)events);
    }

    @Subscribe
    public Result<DESEvent> onWakeUpUserEvent(UserWokeUp evt) {
        this.LOGGER.info((Object)("User woke up: " + ((UserInterpretationContext)evt.getEntity()).getUser()));
        return this.interpretNextAction((UserInterpretationContext)evt.getEntity());
    }

    @Subscribe
    public Result<DESEvent> onUserRequestFinished(UserRequestFinished evt) {
        Preconditions.checkArgument((((UserRequest)evt.getEntity()).getUser().getStack().size() == 2 ? 1 : 0) != 0);
        ((UserRequest)evt.getEntity()).getUser().getStack().removeStackFrame();
        SimulatedStackframe resultFrame = evt.getUserContext().getResultFrame();
        SimulatedStackframe topMostFrame = ((UserRequest)evt.getEntity()).getUser().getStack().currentStackFrame();
        EList outVariables = ((UserRequest)evt.getEntity()).getOutVariableUsages();
        SimulatedStackHelper.addParameterToStackFrame((SimulatedStackframe)resultFrame, (EList)outVariables, (SimulatedStackframe)topMostFrame);
        return this.interpretNextAction(evt.getUserContext());
    }

    @Subscribe
    public Result<DESEvent> onUserFinished(UserFinished evt) {
        this.LOGGER.info((Object)("User finished: " + evt.getEntity()));
        UserInterpretationContext context = (UserInterpretationContext)evt.getEntity();
        return this.finishUserInterpretation(context);
    }

    @Subscribe
    public Result<DESEvent> onUserAborted(UserAborted evt) {
        HashSet<DESEvent> resultSet = new HashSet<DESEvent>();
        this.LOGGER.info((Object)("User aborted, lets restart, user: " + evt.getEntity()));
        UserInterpretationContext context = (UserInterpretationContext)evt.getEntity();
        this.abortUser(resultSet, context);
        return Result.of(resultSet);
    }

    private Result<DESEvent> finishUserInterpretation(UserInterpretationContext context) {
        HashSet<Object> resultSet = new HashSet<Object>();
        assert (context.getUser().getStack().size() == 1);
        context.getUser().getStack().removeStackFrame();
        if (context instanceof ClosedWorkloadUserInterpretationContext) {
            ClosedWorkloadUserInterpretationContext closedContext = (ClosedWorkloadUserInterpretationContext)context;
            resultSet.add(new ClosedWorkloadUserInitiated((UserInterpretationContext)closedContext, closedContext.getThinkTime()));
        }
        resultSet.add(new UsageScenarioFinished(context, 0.0));
        return Result.of(resultSet);
    }

    private void abortUser(Set<DESEvent> resultSet, UserInterpretationContext context) {
        if (context instanceof ClosedWorkloadUserInterpretationContext) {
            ClosedWorkloadUserInterpretationContext closedContext = (ClosedWorkloadUserInterpretationContext)context;
            closedContext = ((ClosedWorkloadUserInterpretationContext.Builder)closedContext.update().withUser(new User())).build();
            resultSet.add((DESEvent)new ClosedWorkloadUserInitiated((UserInterpretationContext)closedContext, closedContext.getThinkTime()));
        }
    }

    @Subscribe
    public Result<DESEvent> onClosedWorkloadUserInitiated(ClosedWorkloadUserInitiated closedWorkloadUserInitiated) {
        RootScenarioContext updatedRootScenarioContext = new RootScenarioContext(((UserInterpretationContext)closedWorkloadUserInitiated.getEntity()).getBehaviorContext().getScenarioBehavior());
        UsageScenarioInterpreter usageScenarioInterpreter = new UsageScenarioInterpreter(((UserInterpretationContext)closedWorkloadUserInitiated.getEntity()).update().withUsageScenarioBehaviorContext((UsageScenarioBehaviorContext)updatedRootScenarioContext).build());
        return Result.of((Collection)usageScenarioInterpreter.doSwitch((EObject)updatedRootScenarioContext.startScenario()));
    }

    @Subscribe
    public Result<DESEvent> onInnerScenarioBehaviorInitiated(InnerScenarioBehaviorInitiated innerScenarioBehaviorInitiated) {
        UserInterpretationContext userInterpretationContext = (UserInterpretationContext)innerScenarioBehaviorInitiated.getEntity();
        UsageScenarioInterpreter usageScenarioInterpreter = new UsageScenarioInterpreter(userInterpretationContext);
        Object events = usageScenarioInterpreter.doSwitch((EObject)userInterpretationContext.getCurrentAction());
        return Result.of((Collection)events);
    }

    @Subscribe
    public Result<DESEvent> onUserInterpretationProgressed(UserInterpretationProgressed userProgressed) {
        UserInterpretationContext userInterpretationContext = (UserInterpretationContext)userProgressed.getEntity();
        UsageScenarioInterpreter usageScenarioInterpreter = new UsageScenarioInterpreter(userInterpretationContext);
        Object events = usageScenarioInterpreter.doSwitch((EObject)userInterpretationContext.getCurrentAction());
        return Result.of((Collection)events);
    }

    private Result<DESEvent> interpretNextAction(UserInterpretationContext context) {
        UsageScenarioInterpreter interpreter = new UsageScenarioInterpreter(context);
        return Result.of((Collection)interpreter.doSwitch((EObject)context.getCurrentAction()));
    }
}

