/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usagesimulation.interpreters;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.InterArrivalTime;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.User;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.UserRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.ClosedWorkloadUserInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.OpenWorkloadUserInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.interpretationcontext.UserInterpretationContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior.BranchScenarioContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior.LoopScenarioBehaviorContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior.RootScenarioContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.scenariobehavior.UsageScenarioBehaviorContext;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.InnerScenarioBehaviorInitiated;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.InterArrivalUserInitiated;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UsageModelPassedElement;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserEntryRequested;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserInterpretationProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserSlept;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserStarted;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.events.UserWokeUp;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.common.utils.TransitionDeterminer;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelSwitch;

public class UsageScenarioInterpreter
extends UsagemodelSwitch<Set<DESEvent>> {
    private static final Logger LOGGER = Logger.getLogger(UsageScenarioInterpreter.class);
    private final UserInterpretationContext userContext;

    public UsageScenarioInterpreter(UserInterpretationContext userContext) {
        this.userContext = userContext;
    }

    public Set<DESEvent> caseLoop(Loop loop) {
        int numberOfLoops = (Integer)StackContext.evaluateStatic((String)loop.getLoopIteration_Loop().getSpecification(), Integer.class);
        LOGGER.debug((Object)("Interpret loop. Maximum loop number: " + numberOfLoops));
        ScenarioBehaviour bodyBehavior = loop.getBodyBehaviour_Loop();
        LoopScenarioBehaviorContext behaviorContext = ((LoopScenarioBehaviorContext.Builder)((LoopScenarioBehaviorContext.Builder)((LoopScenarioBehaviorContext.Builder)LoopScenarioBehaviorContext.builder().withNextAction(Optional.of(loop.getSuccessor()))).withParent(Optional.of(this.userContext.getBehaviorContext()))).withScenarioBehavior(bodyBehavior)).withMaximalLoopCount(numberOfLoops).build();
        AbstractUserAction firstLoopAction = behaviorContext.startScenario();
        UserInterpretationContext newContext = this.userContext.update().withCurrentAction(firstLoopAction).withUsageScenarioBehaviorContext((UsageScenarioBehaviorContext)behaviorContext).build();
        InnerScenarioBehaviorInitiated behaviorInitiated = new InnerScenarioBehaviorInitiated(newContext, 0.0);
        return Set.of(behaviorInitiated);
    }

    public Set<DESEvent> caseEntryLevelSystemCall(EntryLevelSystemCall object) {
        LOGGER.debug((Object)"Entering EntryLevelSystemCall");
        OperationProvidedRole opProvidedRole = object.getProvidedRole_EntryLevelSystemCall();
        OperationSignature signature = object.getOperationSignature__EntryLevelSystemCall();
        EList inputParameterUsages = object.getInputParameterUsages_EntryLevelSystemCall();
        EList outpuParameterUsages = object.getOutputParameterUsages_EntryLevelSystemCall();
        UserRequest userRequest = UserRequest.builder().withUser(this.userContext.getUser()).withOperationProvidedRole(opProvidedRole).withOperationSignature(signature).withVariableUsages(inputParameterUsages).withOutVariableUsages(outpuParameterUsages).build();
        UserEntryRequested userEntryRequest = new UserEntryRequested(userRequest, this.userContext.update().withCurrentAction(object.getSuccessor()).withResultFrame(new SimulatedStackframe()).build(), 0.0);
        return Set.of(userEntryRequest);
    }

    public Set<DESEvent> caseStop(Stop object) {
        if (this.userContext.getBehaviorContext().isChildContext()) {
            if (this.userContext.getBehaviorContext() instanceof LoopScenarioBehaviorContext && ((LoopScenarioBehaviorContext)this.userContext.getBehaviorContext()).mustRepeatScenario()) {
                LoopScenarioBehaviorContext loopCtxt = (LoopScenarioBehaviorContext)this.userContext.getBehaviorContext();
                Object interpretationResultSet = this.doSwitch((EObject)loopCtxt.startScenario());
                return interpretationResultSet;
            }
            UsageScenarioBehaviorContext parentBehaviorContext = (UsageScenarioBehaviorContext)this.userContext.getBehaviorContext().getParent().get();
            Optional nextAbstractUserAction = this.userContext.getBehaviorContext().getNextAction();
            UserInterpretationContext newUserInterpretationContext = this.userContext.update().withUsageScenarioBehaviorContext(parentBehaviorContext).withCurrentAction((AbstractUserAction)nextAbstractUserAction.get()).build();
            return Set.of(new UserInterpretationProgressed(newUserInterpretationContext));
        }
        return Set.of(new UserFinished(this.userContext));
    }

    public Set<DESEvent> caseStart(Start object) {
        Set<UserInterpretationProgressed> resultSet;
        if (this.userContext.getBehaviorContext().isChildContext()) {
            resultSet = Set.of(new UserInterpretationProgressed(this.userContext.updateAction(object.getSuccessor())));
        } else if (this.userContext instanceof ClosedWorkloadUserInterpretationContext) {
            resultSet = Set.of(new UserStarted(this.userContext.updateAction(object.getSuccessor())));
        } else if (this.userContext instanceof OpenWorkloadUserInterpretationContext) {
            OpenWorkloadUserInterpretationContext openWorkloadUserContext = (OpenWorkloadUserInterpretationContext)this.userContext;
            double interArrivalTime = (Double)openWorkloadUserContext.getInterArrivalTime().calculateRV();
            UsageScenario startedScenario = object.getScenarioBehaviour_AbstractUserAction().getUsageScenario_SenarioBehaviour();
            AbstractUserAction firstAction = startedScenario.getScenarioBehaviour_UsageScenario().getActions_ScenarioBehaviour().stream().filter(Start.class::isInstance).findFirst().orElseThrow(() -> new IllegalStateException("There must be a Start user action within the usage scenario."));
            OpenWorkload workloadSpec = (OpenWorkload)startedScenario.getWorkload_UsageScenario();
            PCMRandomVariable interArrivalRV = workloadSpec.getInterArrivalTime_OpenWorkload();
            RootScenarioContext nextScenarioContext = ((RootScenarioContext.Builder)RootScenarioContext.builder().withScenarioBehavior(startedScenario.getScenarioBehaviour_UsageScenario())).build();
            OpenWorkloadUserInterpretationContext nextOpenWorkloadUserInterpretationContext = ((OpenWorkloadUserInterpretationContext.Builder)((OpenWorkloadUserInterpretationContext.Builder)((OpenWorkloadUserInterpretationContext.Builder)((OpenWorkloadUserInterpretationContext.Builder)OpenWorkloadUserInterpretationContext.builder().withUser(new User())).withScenario(startedScenario)).withCurrentAction(firstAction)).withInterArrivalTime(new InterArrivalTime(interArrivalRV)).withUsageScenarioBehaviorContext((UsageScenarioBehaviorContext)nextScenarioContext)).build();
            resultSet = Set.of(new UserStarted(this.userContext.updateAction(object.getSuccessor())), new InterArrivalUserInitiated((UserInterpretationContext)nextOpenWorkloadUserInterpretationContext, interArrivalTime));
        } else {
            LOGGER.info((Object)"The user is neither a closed workload nor open workload user");
            throw new IllegalStateException("The user must be a open workload or closed workload user");
        }
        return resultSet;
    }

    public Set<DESEvent> caseBranch(Branch branch) {
        TransitionDeterminer transitionDeterminer = new TransitionDeterminer(this.userContext.getUser().getStack().currentStackFrame());
        BranchTransition branchTransition = transitionDeterminer.determineBranchTransition(branch.getBranchTransitions_Branch());
        AbstractUserAction firstBranchAction = branchTransition.getBranchedBehaviour_BranchTransition().getActions_ScenarioBehaviour().stream().filter(Start.class::isInstance).findFirst().orElseThrow(() -> new IllegalStateException("There is no start action within the branch transition!"));
        BranchScenarioContext behaviorContext = ((BranchScenarioContext.Builder)((BranchScenarioContext.Builder)((BranchScenarioContext.Builder)BranchScenarioContext.builder().withParent(Optional.of(this.userContext.getBehaviorContext()))).withNextAction(Optional.of(branch.getSuccessor()))).withScenarioBehavior(branchTransition.getBranchedBehaviour_BranchTransition())).build();
        UserInterpretationContext newContext = this.userContext.update().withCurrentAction(firstBranchAction).withUsageScenarioBehaviorContext((UsageScenarioBehaviorContext)behaviorContext).build();
        InnerScenarioBehaviorInitiated innerScenarioBehaviorInitiated = new InnerScenarioBehaviorInitiated(newContext, 0.0);
        return Set.of(innerScenarioBehaviorInitiated);
    }

    public Set<DESEvent> caseUsageScenario(UsageScenario object) {
        return this.doSwitch((EObject)object.getScenarioBehaviour_UsageScenario());
    }

    public Set<DESEvent> caseAbstractUserAction(AbstractUserAction object) {
        LOGGER.debug((Object)("Interpret " + object.eClass().getName() + ": " + object));
        return Set.of();
    }

    public Set<DESEvent> caseScenarioBehaviour(ScenarioBehaviour object) {
        for (AbstractUserAction abstractUserAction : object.getActions_ScenarioBehaviour()) {
            if (!(abstractUserAction instanceof Start)) continue;
            return this.doSwitch((EObject)abstractUserAction);
        }
        return Set.of();
    }

    public Set<DESEvent> caseDelay(Delay object) {
        double delay = (Double)StackContext.evaluateStatic((String)object.getTimeSpecification_Delay().getSpecification(), Double.class);
        UserInterpretationContext updatedUserContext = this.userContext.updateAction(object.getSuccessor());
        return Set.of(new UserSlept(updatedUserContext), new UserWokeUp(updatedUserContext, delay));
    }

    public Set<DESEvent> doSwitch(EObject eObject) {
        if (eObject == null) {
            throw new IllegalArgumentException("called interpretation on a null reference");
        }
        HashSet<DESEvent> result = new HashSet<DESEvent>();
        Set returningEvents = (Set)super.doSwitch(eObject);
        result.add((DESEvent)new UsageModelPassedElement(eObject, this.userContext));
        if (returningEvents != null) {
            result.addAll(returningEvents);
        }
        return result;
    }
}

