/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usagesimulation.repositories;

import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.analyzer.slingshot.behavior.usagesimulation.repositories.UsageModelRepository;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;
import org.palladiosimulator.pcm.usagemodel.Workload;

public class UsageModelRepositoryImpl
implements UsageModelRepository {
    private final Logger LOGGER = Logger.getLogger(UsageModelRepositoryImpl.class);
    private UsageModel usageModel = UsagemodelFactory.eINSTANCE.createUsageModel();

    @Override
    public List<UsageScenario> findAllUsageScenarios() {
        EList usageScenarios = this.usageModel.getUsageScenario_UsageModel();
        return usageScenarios;
    }

    @Override
    public Optional<Workload> findWorkloadForUsageScenario(UsageScenario usageScenario) {
        return this.findAllUsageScenarios().stream().filter(scenario -> scenario.getId().equals(usageScenario.getId())).map(UsageScenario::getWorkload_UsageScenario).findFirst();
    }

    @Override
    public void load(UsageModel usageModel) {
        this.usageModel = usageModel;
    }

    @Override
    public int findClosedWorkloadPopulation(ClosedWorkload workload) {
        return workload.getPopulation();
    }

    @Override
    public Optional<AbstractUserAction> findFirstActionOf(UsageScenario scenario) {
        return scenario.getScenarioBehaviour_UsageScenario().getActions_ScenarioBehaviour().stream().filter(Start.class::isInstance).findFirst();
    }
}

