/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.common.events.modelchanges;

import java.util.Collections;
import java.util.List;
import org.palladiosimulator.analyzer.slingshot.common.events.modelchanges.ModelChange;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;

public class ResourceEnvironmentChange
extends ModelChange<ResourceEnvironment> {
    private final List<ResourceContainer> oldResourceContainers;
    private final List<ResourceContainer> newResourceContainers;
    private final List<ResourceContainer> deletedResourceContainers;

    public ResourceEnvironmentChange(Builder builder) {
        super(builder.environment, builder.simulationTime);
        this.oldResourceContainers = Collections.unmodifiableList(builder.oldResourceContainers);
        this.newResourceContainers = Collections.unmodifiableList(builder.newResourceContainers);
        this.deletedResourceContainers = Collections.unmodifiableList(builder.deletedResourceContainers);
    }

    public List<ResourceContainer> getOldResourceContainers() {
        return this.oldResourceContainers;
    }

    public List<ResourceContainer> getNewResourceContainers() {
        return this.newResourceContainers;
    }

    public List<ResourceContainer> getDeletedResourceContainers() {
        return this.deletedResourceContainers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ResourceEnvironment environment;
        private double simulationTime = -1.0;
        private List<ResourceContainer> oldResourceContainers;
        private List<ResourceContainer> newResourceContainers;
        private List<ResourceContainer> deletedResourceContainers;

        private Builder() {
        }

        public Builder resourceEnvironment(ResourceEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public Builder simulationTime(double simulationTime) {
            this.simulationTime = simulationTime;
            return this;
        }

        public Builder oldResourceContainers(List<ResourceContainer> oldResourceContainers) {
            this.oldResourceContainers = oldResourceContainers;
            return this;
        }

        public Builder newResourceContainers(List<ResourceContainer> newResourceContainers) {
            this.newResourceContainers = newResourceContainers;
            return this;
        }

        public Builder deletedResourceContainers(List<ResourceContainer> deletedResourceContainers) {
            this.deletedResourceContainers = deletedResourceContainers;
            return this;
        }

        public ResourceEnvironmentChange build() {
            return new ResourceEnvironmentChange(this);
        }
    }
}

