/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.common.events;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.palladiosimulator.analyzer.slingshot.common.events.AbstractEvent;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;

public abstract class AbstractSimulationEvent
extends AbstractEvent
implements DESEvent {
    private double scheduledTime;
    private final double delay;

    public AbstractSimulationEvent() {
        this(0.0);
    }

    public AbstractSimulationEvent(String id, double delay) {
        super(id);
        this.delay = delay;
        Preconditions.checkArgument((delay >= 0.0 ? 1 : 0) != 0, (Object)("Delay must be at least 0, but is " + delay));
    }

    public AbstractSimulationEvent(double delay) {
        this(UUID.randomUUID().toString(), delay);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public double time() {
        return this.scheduledTime;
    }

    @Override
    public final void setTime(double time) {
        this.scheduledTime = time;
    }

    @Override
    public double delay() {
        return this.delay;
    }
}

