/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.core.extension;

import com.google.inject.AbstractModule;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.core.extension.ModelProvider;

public abstract class AbstractSlingshotExtension
extends AbstractModule {
    private static final Logger LOGGER = LogManager.getLogger(AbstractSlingshotExtension.class);
    private List<Class<?>> behaviorExtensions;
    private Map<Class<?>, Class<? extends Provider<?>>> bindee2provider;

    protected final void install(Class<?> behaviorExtension) {
        if (this.behaviorExtensions == null) {
            this.behaviorExtensions = new LinkedList();
        }
        if (!this.behaviorExtensions.contains(behaviorExtension)) {
            LOGGER.debug((Object)String.format("Installing %s.", behaviorExtension.getSimpleName()));
            this.behaviorExtensions.add(behaviorExtension);
        } else {
            LOGGER.debug((Object)String.format("Skip Installing %s, as it is already installed.", behaviorExtension.getSimpleName()));
        }
    }

    protected final <T extends EObject> void provideModel(Class<T> model, Class<? extends ModelProvider<T>> provider) {
        this.bind(model).toProvider(provider);
    }

    protected final <T> void install(Class<T> bindee, Class<? extends Provider<T>> provider) {
        if (this.bindee2provider == null) {
            this.bindee2provider = new HashMap();
        }
        this.bindee2provider.put(bindee, provider);
    }

    public final <T> Map<Class<T>, Class<? extends Provider<T>>> getBindee2provider() {
        HashMap<Class<T>, Class<Provider<T>>> rval = new HashMap<Class<T>, Class<Provider<T>>>();
        if (this.bindee2provider != null) {
            for (Map.Entry<Class<?>, Class<Provider<?>>> entry : this.bindee2provider.entrySet()) {
                Class<?> bindeee = entry.getKey();
                Class<? extends Provider<?>> provider = entry.getValue();
                rval.put(bindeee, provider);
            }
        }
        return rval;
    }

    protected abstract void configure();

    public final List<Class<?>> getBehaviorExtensions() {
        if (this.behaviorExtensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.behaviorExtensions);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

