/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.core.extension;

import com.google.inject.AbstractModule;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.core.extension.AbstractSlingshotExtension;
import org.palladiosimulator.analyzer.slingshot.core.extension.SystemBehaviorExtension;

public final class SystemBehaviorContainer
extends AbstractModule {
    private static final Logger LOGGER = LogManager.getLogger(SystemBehaviorContainer.class);
    private AbstractSlingshotExtension extension;

    public SystemBehaviorContainer(AbstractSlingshotExtension extension) {
        this.extension = extension;
    }

    public void configure() {
        this.extension.getBehaviorExtensions().stream().filter(extension -> SystemBehaviorExtension.class.isAssignableFrom((Class<?>)extension)).peek(clazz -> LOGGER.debug((Object)("Following system behavior class detected: " + clazz.getName()))).forEach(arg_0 -> ((SystemBehaviorContainer)this).bind(arg_0));
    }

    public List<Class<? extends SystemBehaviorExtension>> getExtensions() {
        return this.extension.getBehaviorExtensions().stream().filter(extension -> SystemBehaviorExtension.class.isAssignableFrom((Class<?>)extension)).map(extension -> extension).collect(Collectors.toUnmodifiableList());
    }
}

