/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.core;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.core.Slingshot;
import org.palladiosimulator.analyzer.slingshot.core.annotations.SimulationBehaviorExtensions;
import org.palladiosimulator.analyzer.slingshot.core.annotations.SystemBehaviorExtensions;
import org.palladiosimulator.analyzer.slingshot.core.api.SystemDriver;
import org.palladiosimulator.analyzer.slingshot.core.driver.SlingshotSystemDriver;
import org.palladiosimulator.analyzer.slingshot.core.extension.AbstractSlingshotExtension;
import org.palladiosimulator.analyzer.slingshot.core.extension.PCMResourceSetPartitionProvider;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorContainer;
import org.palladiosimulator.analyzer.slingshot.core.extension.SystemBehaviorContainer;

public class SlingshotModule
extends AbstractModule {
    private final Logger LOGGER = LogManager.getLogger(SlingshotModule.class);
    private final List<SystemBehaviorContainer> systemContainers = Slingshot.getInstance().getExtensions().stream().map(extension -> new SystemBehaviorContainer((AbstractSlingshotExtension)((Object)extension))).collect(Collectors.toList());
    private final List<SimulationBehaviorContainer> simulationContainers = Slingshot.getInstance().getExtensions().stream().map(SimulationBehaviorContainer::new).collect(Collectors.toList());

    protected void configure() {
        this.bind(PCMResourceSetPartitionProvider.class);
        this.bind(SystemDriver.class).to(SlingshotSystemDriver.class);
    }

    @Singleton
    @Provides
    @SystemBehaviorExtensions
    public List<SystemBehaviorContainer> getSystemBehaviorContainers() {
        return this.systemContainers;
    }

    @Singleton
    @Provides
    @SimulationBehaviorExtensions
    public List<SimulationBehaviorContainer> getSimulationBehaviorContainer() {
        return this.simulationContainers;
    }
}

