/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.core.engine;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Singleton;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.core.api.SimulationEngine;
import org.palladiosimulator.analyzer.slingshot.core.api.SimulationInformation;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.Bus;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.Subscriber;
import umontreal.ssj.simevents.Event;
import umontreal.ssj.simevents.Simulator;

@Singleton
public class SimulationEngineSSJ
implements SimulationEngine,
SimulationInformation {
    private final Logger LOGGER = LogManager.getLogger(SimulationEngineSSJ.class);
    private final Bus eventBus = Bus.instance();
    private final Simulator simulator = new Simulator();
    private int cumulativeEvents = 0;
    private boolean isAcceptingEvents = false;

    @Override
    public void init() {
        this.simulator.init();
        this.isAcceptingEvents = true;
    }

    @Override
    public void scheduleEvent(DESEvent event) {
        if (!this.isAcceptingEvents) {
            return;
        }
        if (event.time() > 0.0) {
            this.scheduleEventAt(event, event.time());
            return;
        }
        SSJEvent simulationEvent = new SSJEvent(event);
        this.LOGGER.debug((Object)("Schedule event " + event.getName() + " with delay " + event.delay()));
        simulationEvent.schedule(event.delay());
    }

    @Override
    public void scheduleEventAt(DESEvent event, double simulationTime) {
        if (!this.isAcceptingEvents) {
            return;
        }
        SSJEvent simulationEvent = new SSJEvent(event);
        simulationEvent.setTime(simulationTime + event.delay());
        this.simulator.getEventList().add((Event)simulationEvent);
    }

    @Override
    public SimulationInformation getSimulationInformation() {
        return this;
    }

    @Override
    public void start() {
        this.simulator.start();
        this.eventBus.acceptEvents(true);
    }

    @Override
    public void stop() {
        this.simulator.stop();
        this.eventBus.acceptEvents(false);
        this.isAcceptingEvents = false;
    }

    @Override
    public boolean isRunning() {
        return this.simulator.isSimulating();
    }

    @Override
    public double currentSimulationTime() {
        return this.simulator.time();
    }

    @Override
    public int consumedEvents() {
        return this.cumulativeEvents;
    }

    @Override
    public void registerEventListener(SimulationBehaviorExtension guavaEventClass) {
        this.eventBus.register((Object)guavaEventClass);
    }

    @Override
    public <T> void registerEventListener(Subscriber<T> subscriber) {
        this.eventBus.register(subscriber);
    }

    @Override
    public Set<DESEvent> getScheduledEvents() {
        Iterator events = this.simulator.getEventList().iterator();
        HashSet<DESEvent> desevents = new HashSet<DESEvent>();
        while (events.hasNext()) {
            SSJEvent ssjEvent = (SSJEvent)((Object)events.next());
            DESEvent desevent = ssjEvent.getDESEvent();
            desevent.setTime(ssjEvent.time());
            desevents.add(desevent);
        }
        return desevents;
    }

    private final class SSJEvent
    extends Event {
        private final DESEvent event;

        private SSJEvent(DESEvent correspondingEvent) {
            super(SimulationEngineSSJ.this.simulator);
            this.event = correspondingEvent;
        }

        public void actions() {
            if (this.simulator().isStopped()) {
                return;
            }
            SimulationEngineSSJ.this.LOGGER.info((Object)String.format("Event dispatched at %f: %s (%s)", this.simulator().time(), this.event.getName(), this.event.getId()));
            this.event.setTime(this.simulator().time());
            SimulationEngineSSJ.this.eventBus.post((Object)this.event);
            ++SimulationEngineSSJ.this.cumulativeEvents;
        }

        private DESEvent getDESEvent() {
            return this.event;
        }
    }
}

