/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.core;

import com.google.inject.Injector;
import java.util.Collections;
import java.util.List;
import javax.inject.Provider;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.palladiosimulator.analyzer.slingshot.core.InjectorHolder;
import org.palladiosimulator.analyzer.slingshot.core.SimulationModule;
import org.palladiosimulator.analyzer.slingshot.core.api.SimulationDriver;
import org.palladiosimulator.analyzer.slingshot.core.api.SystemDriver;
import org.palladiosimulator.analyzer.slingshot.core.extension.AbstractSlingshotExtension;
import org.palladiosimulator.commons.eclipseutils.ExtensionHelper;

public class Slingshot
extends Plugin {
    private static final Logger LOGGER = LogManager.getLogger(Slingshot.class);
    public static final String BUNDLE_ID = "";
    private static Slingshot bundle = null;
    private List<AbstractSlingshotExtension> extensions = null;
    private InjectorHolder injectionHolder;

    static {
        Slingshot.setupLoggingLevel();
    }

    public void start(BundleContext context) throws Exception {
        bundle = this;
        this.injectionHolder = new InjectorHolder();
        LOGGER.debug((Object)"Slingshot started");
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        bundle = null;
        this.extensions = null;
        this.injectionHolder = null;
        LOGGER.debug((Object)"Slingshot ended");
        super.stop(context);
    }

    public List<AbstractSlingshotExtension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = ExtensionHelper.getExecutableExtensions((String)"org.palladiosimulator.analyzer.slingshot", (String)"module");
        }
        return Collections.unmodifiableList(this.extensions);
    }

    public static Slingshot getInstance() {
        return bundle;
    }

    public SystemDriver getSystemDriver() {
        return this.injectionHolder.getInstance(SystemDriver.class);
    }

    public SimulationDriver getSimulationDriver() {
        Injector parent = this.injectionHolder.getInstance(Injector.class);
        Injector child = parent.createChildInjector(List.of(new SimulationModule()));
        return (SimulationDriver)child.getInstance(SimulationDriver.class);
    }

    public <T> T getInstance(Class<T> clazz) {
        return this.injectionHolder.getInstance(clazz);
    }

    public <T> Provider<T> getProvider(Class<T> clazz) {
        return this.injectionHolder.getProvider(clazz);
    }

    private static void setupLoggingLevel() {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.removeAllAppenders();
        PatternLayout layout = new PatternLayout("%n\tat %C.%M(%F:%L)%n\t%-5p %d [%t] - %m%n");
        ConsoleAppender app = new ConsoleAppender((Layout)layout);
        rootLogger.addAppender((Appender)app);
    }
}

