/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.core.driver;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provides;
import de.uka.ipd.sdq.simucomframework.core.SimuComConfig;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.core.annotations.SimulationBehaviorExtensions;
import org.palladiosimulator.analyzer.slingshot.core.api.SimulationDriver;
import org.palladiosimulator.analyzer.slingshot.core.api.SimulationEngine;
import org.palladiosimulator.analyzer.slingshot.core.behavior.CoreBehavior;
import org.palladiosimulator.analyzer.slingshot.core.events.PreSimulationConfigurationStarted;
import org.palladiosimulator.analyzer.slingshot.core.events.SimulationFinished;
import org.palladiosimulator.analyzer.slingshot.core.events.SimulationStarted;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorContainer;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.Subscriber;

@Singleton
public class SlingshotSimulationDriver
implements SimulationDriver {
    private boolean running = false;
    private boolean initialized = false;
    private final SimulationEngine engine;
    private final Injector parentInjector;
    private final List<SimulationBehaviorContainer> behaviorContainers;
    private IProgressMonitor monitor;
    private SimuComConfig config;

    @Inject
    public SlingshotSimulationDriver(SimulationEngine engine, Injector injector, @SimulationBehaviorExtensions List<SimulationBehaviorContainer> behaviorContainers) {
        this.engine = engine;
        this.parentInjector = injector;
        this.behaviorContainers = behaviorContainers;
    }

    @Override
    public void init(SimuComConfig config, IProgressMonitor monitor) {
        ArrayList<AbstractModule> partitionIncludedStream = new ArrayList<AbstractModule>(this.behaviorContainers.size() + 1);
        partitionIncludedStream.add(new SimulationDriverSubModule(monitor));
        partitionIncludedStream.addAll(this.behaviorContainers);
        Injector childInjector = this.parentInjector.createChildInjector(partitionIncludedStream);
        this.monitor = monitor;
        this.config = config;
        this.behaviorContainers.stream().flatMap(behaviorContainer -> behaviorContainer.getExtensions().stream()).forEach(simExtensionClass -> {
            Object extension = childInjector.getInstance(simExtensionClass);
            if (!(extension instanceof SimulationBehaviorExtension)) {
                return;
            }
            SimulationBehaviorExtension simExtension = (SimulationBehaviorExtension)extension;
            if (simExtension.isActive()) {
                this.engine.registerEventListener(simExtension);
            }
        });
        this.engine.registerEventListener(new CoreBehavior(this));
        this.initialized = true;
    }

    @Override
    public void start() {
        if (this.isRunning() || !this.initialized) {
            return;
        }
        this.running = true;
        this.engine.init();
        this.scheduleEvent((DESEvent)new PreSimulationConfigurationStarted());
        this.scheduleEvent((DESEvent)new SimulationStarted());
        this.scheduleEventAt((DESEvent)new SimulationFinished(), this.config.getSimuTime());
        this.engine.start();
    }

    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.running = false;
        this.engine.stop();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void scheduleEvent(DESEvent event) {
        if (!this.isRunning()) {
            return;
        }
        this.engine.scheduleEvent(event);
    }

    @Override
    public void scheduleEventAt(DESEvent event, double simulationTime) {
        if (!this.isRunning()) {
            return;
        }
        this.engine.scheduleEventAt(event, simulationTime);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public <T extends DESEvent> void registerEventHandler(Subscriber<T> subscriber) {
        this.engine.registerEventListener(subscriber);
    }

    private class SimulationDriverSubModule
    extends AbstractModule {
        private final IProgressMonitor monitor;

        public SimulationDriverSubModule(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Provides
        public IProgressMonitor monitor() {
            return this.monitor;
        }
    }
}

