/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.core;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.grapher.graphviz.GraphvizGrapher;
import com.google.inject.grapher.graphviz.GraphvizModule;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.core.Slingshot;
import org.palladiosimulator.analyzer.slingshot.core.SlingshotModule;
import org.palladiosimulator.analyzer.slingshot.core.extension.AbstractSlingshotExtension;

public final class InjectorHolder {
    private static final Logger LOGGER = Logger.getLogger(InjectorHolder.class);
    private final Injector injector;

    InjectorHolder() {
        ArrayList<AbstractSlingshotExtension> copied = new ArrayList<AbstractSlingshotExtension>(Slingshot.getInstance().getExtensions());
        copied.add((AbstractSlingshotExtension)((Object)new SlingshotModule()));
        copied.forEach(module -> LOGGER.debug((Object)("Following module added: " + module.getClass().getName())));
        this.injector = Guice.createInjector(copied);
    }

    public <T> T getInstance(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    public <T> T getInstance(Key<T> key) {
        return (T)this.injector.getInstance(key);
    }

    public <T> Provider<T> getProvider(Class<T> clazz) {
        return this.injector.getProvider(clazz);
    }

    public void outputDependecyGraph(String fileName) throws IOException {
        PrintWriter out = new PrintWriter(new File(fileName), "UTF-8");
        Injector graphInjector = Guice.createInjector((Module[])new Module[]{new GraphvizModule()});
        GraphvizGrapher renderer = (GraphvizGrapher)graphInjector.getInstance(GraphvizGrapher.class);
        renderer.setOut(out);
        renderer.setRankdir("TB");
        renderer.graph(this.injector);
    }
}

