/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.core.driver;

import com.google.inject.Injector;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.palladiosimulator.analyzer.slingshot.common.events.SystemEvent;
import org.palladiosimulator.analyzer.slingshot.core.annotations.SystemBehaviorExtensions;
import org.palladiosimulator.analyzer.slingshot.core.api.SystemDriver;
import org.palladiosimulator.analyzer.slingshot.core.extension.SystemBehaviorContainer;
import org.palladiosimulator.analyzer.slingshot.core.extension.SystemBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.Bus;

@Singleton
public class SlingshotSystemDriver
implements SystemDriver {
    private final Bus systemBus = Bus.instance((String)"System");
    private final Injector parentInjector;
    private final List<SystemBehaviorContainer> behaviorContainers;
    private final boolean running = false;

    @Inject
    public SlingshotSystemDriver(Injector parentInjector, @SystemBehaviorExtensions List<SystemBehaviorContainer> behaviorContainer) {
        this.parentInjector = parentInjector;
        this.behaviorContainers = behaviorContainer;
        this.init();
    }

    private void init() {
        Injector childInjector = this.parentInjector.createChildInjector(this.behaviorContainers);
        this.behaviorContainers.stream().flatMap(extensions -> extensions.getExtensions().stream()).forEach(simExtension -> {
            Object e = childInjector.getInstance(simExtension);
            if (!(e instanceof SystemBehaviorExtension)) {
                return;
            }
            this.systemBus.register(e);
        });
    }

    @Override
    public void postEvent(SystemEvent systemEvent) {
        this.systemBus.post((Object)systemEvent);
    }

    @Override
    public void postEventAndThen(SystemEvent systemEvent, Runnable runnable) {
        this.systemBus.post((Object)systemEvent);
        runnable.run();
    }

    @Override
    public boolean isRunning() {
        return false;
    }
}

