/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.eventdriver.entity;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.stream.Collectors;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.Subscriber;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.SubscriberContract;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.interceptors.IPostInterceptor;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.interceptors.IPreInterceptor;
import org.palladiosimulator.analyzer.slingshot.eventdriver.internal.contractchecker.EventContractChecker;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;

public abstract class AnnotatedSubscriber {
    private AnnotatedSubscriber() {
    }

    private static <T> Result<?> acceptEvent(T event, Object target, Method method) throws Throwable {
        Class<?> resultType = method.getReturnType();
        try {
            Result result;
            if (resultType.equals(Void.TYPE) || resultType.equals(Void.class)) {
                result = Result.empty();
                method.invoke(target, event);
            } else {
                result = (Result)method.invoke(target, event);
            }
            return result;
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() != null && (ex.getCause() instanceof Exception || ex.getCause() instanceof AssertionError)) {
                ex.getCause().printStackTrace();
                throw ex.getCause();
            }
            return Result.empty();
        }
    }

    public static <T> Subscriber.Builder<T> fromJavaMethod(Class<T> forEvent, Object target, Method method, Subscribe annotation, IPreInterceptor preInterceptor, IPostInterceptor postInterceptor) {
        return Subscriber.builder(forEvent).associatedContracts(EventContractChecker.getOnEventContract(target, forEvent).map(onEvent -> SubscriberContract.fromAnnotation(onEvent)).collect(Collectors.toList())).handlerType(Method.class).enclosingType(target.getClass()).name(method.getName()).priority(annotation.priority()).reifiedClasses(annotation.reified()).preInterceptor(preInterceptor).postInterceptor(postInterceptor).handler(event -> AnnotatedSubscriber.acceptEvent(event, target, method));
    }
}

