/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.eventdriver.internal;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.eventdriver.Bus;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.OnException;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.PostIntercept;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.PreIntercept;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.AnnotatedSubscriber;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.Subscriber;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.interceptors.CompositeInterceptor;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.interceptors.PostInterceptor;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.interceptors.PreInterceptor;
import org.palladiosimulator.analyzer.slingshot.eventdriver.internal.contractchecker.EventContractChecker;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;

public final class BusImplementation
implements Bus {
    private static final Logger LOGGER = Logger.getLogger(BusImplementation.class);
    private final Subject<Object> bus;
    private final Map<String, CompositeDisposable> observers = new HashMap<String, CompositeDisposable>();
    private final CompositeInterceptor compositeInterceptor = new CompositeInterceptor();
    private final Map<Class<?>, Set<Consumer<? super Throwable>>> exceptionHandlers = new HashMap();
    private final Map<Class<?>, Set<Subscriber<?>>> subscribers = new HashMap();
    private boolean registrationOpened = true;
    private boolean invocationOpened = true;
    private final String identifier;

    public BusImplementation(String identifier) {
        this.identifier = Objects.requireNonNull(identifier);
        this.bus = PublishSubject.create();
        this.init();
    }

    private void init() {
        this.register(new EventContractChecker());
    }

    public BusImplementation() {
        this("default");
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public <T> void register(Subscriber<T> subscriber) {
        if (!this.registrationOpened) {
            throw new IllegalStateException("This bus has closed registration for new subscribers");
        }
        Objects.requireNonNull(subscriber, "Subscriber must not be null!");
        subscriber.addPreInterceptor(this.compositeInterceptor);
        subscriber.addPostInterceptor(this.compositeInterceptor);
        this.observers.computeIfAbsent(subscriber.getEnclosingType().map(Class::getName).orElseGet(subscriber::getName), id -> new CompositeDisposable()).add(this.bus.ofType(subscriber.getEventType()).doOnNext(this::doOnNext).subscribe(subscriber, this::doError));
    }

    @Override
    public void register(Object object) {
        if (!this.registrationOpened) {
            throw new IllegalStateException("This bus does not income new objects.");
        }
        Objects.requireNonNull(object, "Observer to register must not be null.");
        Class<?> observerClass = object.getClass();
        CompositeDisposable composite = this.observers.computeIfAbsent(observerClass.getName(), name -> new CompositeDisposable());
        HashSet<EventType> events = new HashSet<EventType>();
        LOGGER.info((Object)("Register " + object.getClass().getSimpleName()));
        Method[] methodArray = observerClass.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.isBridge() && !method.isSynthetic()) {
                this.searchForSubscribers(composite, events, method, object);
                this.searchExceptionHandlers(method, object);
                this.searchPreInterceptors(method, object);
                this.searchPostInterceptors(method, object);
            }
            ++n2;
        }
    }

    @Override
    public void unregister(Object object) {
        Objects.requireNonNull(object, "Observer to unregister must not be null.");
        CompositeDisposable composite = object instanceof String ? this.observers.remove(object) : this.observers.remove(object.getClass().getName());
        Objects.requireNonNull(composite, "Missing observer; it was not registered before.");
        composite.dispose();
        Set<Subscriber<?>> subscribers = this.subscribers.remove(this.observers.getClass());
        if (subscribers != null) {
            subscribers.clear();
        }
    }

    @Override
    public void post(Object event) {
        if (!this.invocationOpened) {
            throw new IllegalStateException("The bus is not currently allowing posting of events.");
        }
        LOGGER.debug((Object)("Now post " + event.getClass().getSimpleName()));
        this.bus.onNext(Objects.requireNonNull(event));
    }

    private void searchForSubscribers(CompositeDisposable composite, Set<EventType> events, Method method, Object object) {
        if (!method.isAnnotationPresent(Subscribe.class)) {
            return;
        }
        int modifiers = method.getModifiers();
        Subscribe subscribeAnnotation = method.getAnnotation(Subscribe.class);
        if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new IllegalArgumentException("Method " + method.getName() + " has @Subscribe annotation, but is static or is not public.");
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("Method " + method.getName() + " has @Subscribe annotation, but has either 0 or more than one parameters.");
        }
        Class<?> eventClass = parameterTypes[0];
        EventType eventType = new EventType(eventClass, subscribeAnnotation.reified());
        if (!events.add(eventType)) {
            throw new IllegalArgumentException("Subscriber for " + eventType.toString() + " has already been registered.");
        }
        EventContractChecker.checkEventContract(method, object, eventClass);
        Class<?> returnType = method.getReturnType();
        if (!(returnType.equals(Void.TYPE) || returnType.equals(Void.class) || returnType.equals(Result.class))) {
            throw new IllegalArgumentException("Observables must return either void (primitive), Void (object) or Result, but this method returns " + returnType.getSimpleName());
        }
        this.register(AnnotatedSubscriber.fromJavaMethod(eventClass, object, method, subscribeAnnotation, this.compositeInterceptor, this.compositeInterceptor).build());
    }

    private void doError(Throwable error) {
        LOGGER.error((Object)("An error occurred: " + error.getClass().getSimpleName() + ":: " + error.getMessage()), error);
        this.exceptionHandlers.keySet().stream().filter(exClazz -> exClazz.isAssignableFrom(error.getClass())).flatMap(exClazz -> this.exceptionHandlers.get(exClazz).stream()).forEach(exHandler -> exHandler.accept(error));
    }

    private void doOnNext(Object event) {
        LOGGER.debug((Object)("About to call the subscribers for the following events: " + event.getClass().getSimpleName()));
    }

    private void searchPreInterceptors(Method method, Object object) {
        if (!method.isAnnotationPresent(PreIntercept.class)) {
            return;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Method " + method.getName() + " for pre-interception is not public.");
        }
        PreInterceptor preInterceptor = new PreInterceptor(method, object);
        this.compositeInterceptor.add(preInterceptor.forEvent(), preInterceptor);
    }

    private void searchPostInterceptors(Method method, Object object) {
        if (!method.isAnnotationPresent(PostIntercept.class)) {
            return;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Method " + method.getName() + " for post-interception is not public.");
        }
        PostInterceptor postInterceptor = new PostInterceptor(method, object);
        this.compositeInterceptor.add(postInterceptor.forEvent(), postInterceptor);
    }

    private void searchExceptionHandlers(Method method, Object target) {
        if (!method.isAnnotationPresent(OnException.class)) {
            return;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("");
        }
        if (!Throwable.class.isAssignableFrom(params[0])) {
            throw new IllegalArgumentException("First parameter must be throwable type");
        }
        Consumer<Throwable> onException = exception -> {
            try {
                method.invoke(target, exception);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception2) {}
        };
        this.exceptionHandlers.computeIfAbsent(params[0], eventType -> new HashSet()).add(onException);
    }

    @Override
    public void closeRegistration() {
        this.registrationOpened = false;
        this.invocationOpened = true;
    }

    @Override
    public void acceptEvents(boolean accept) {
        if (this.registrationOpened) {
            return;
        }
        this.invocationOpened = accept;
    }

    public static class EventType {
        private final Class<?> eventClass;
        private Class<?>[] reification;

        public EventType(Class<?> eventClass, Class<?>[] reification) {
            this.eventClass = eventClass;
            this.reification = reification;
            if (this.reification == null) {
                this.reification = new Class[0];
            }
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.reification);
            result = 31 * result + Objects.hash(this.eventClass);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventType other = (EventType)obj;
            return Objects.equals(this.eventClass, other.eventClass) && Arrays.equals(this.reification, other.reification);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("EventType[event = <");
            stringBuilder.append(this.eventClass.getName());
            stringBuilder.append(">, reified = {");
            Class<?>[] classArray = this.reification;
            int n = this.reification.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                stringBuilder.append("<");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(">");
                ++n2;
            }
            stringBuilder.append("}]");
            return stringBuilder.toString();
        }
    }
}

