/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class Result<T> {
    private Set<T> resultEvents;

    private Result(Collection<T> resultEvents) {
        if (resultEvents != null) {
            this.resultEvents = new HashSet<T>(resultEvents);
            this.resultEvents.remove(null);
        } else {
            this.resultEvents = Collections.emptySet();
        }
    }

    public Set<Object> getResultEvents() {
        return Collections.unmodifiableSet(this.resultEvents);
    }

    public static <T> Result<T> of(T ... events) {
        return new Result<T>(List.of(events));
    }

    public static <T, S extends T> Result<T> of(Collection<S> resultEvents) {
        return new Result<S>(List.copyOf(resultEvents));
    }

    public static <T, S extends T> Result<T> of(Optional<S> resultEvent) {
        if (resultEvent.isPresent()) {
            return new Result<S>(List.of(resultEvent.get()));
        }
        return new Result(List.of());
    }

    @Deprecated
    public static <T> Result<T> from(Collection<T> resultEvents) {
        return new Result<T>(resultEvents);
    }

    public static <T> Result<T> empty() {
        return new Result<T>(null);
    }
}

