/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.eventdriver.entity;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.EventHandler;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.ReifiedEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.SubscriberContract;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.interceptors.IPostInterceptor;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.interceptors.IPreInterceptor;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.interceptors.InterceptorInformation;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.InterceptionResult;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;

public class Subscriber<T>
implements Consumer<T>,
Disposable,
Comparable<Subscriber<T>>,
InterceptorInformation {
    private static final Logger LOGGER = Logger.getLogger(Subscriber.class);
    private boolean disposed = false;
    private final int priority;
    private final List<Class<?>> reifiedClasses;
    private final String name;
    private final EventHandler<? super T> handler;
    private final Class<?> handlerType;
    private final Optional<Class<?>> enclosingType;
    private final Class<T> forEvent;
    private Optional<IPreInterceptor> preInterceptor;
    private Optional<IPostInterceptor> postInterceptor;
    private final List<SubscriberContract> associatedContracts;

    private Subscriber(Builder<T> builder) {
        this.priority = builder.priority;
        this.reifiedClasses = builder.reifiedClasses;
        this.name = builder.name;
        this.handler = builder.handler;
        this.handlerType = builder.handlerType;
        this.enclosingType = builder.enclosingType;
        this.forEvent = builder.forEvent;
        this.preInterceptor = builder.preInterceptor;
        this.postInterceptor = builder.postInterceptor;
        this.associatedContracts = builder.associatedContracts;
    }

    public void accept(T event) throws Throwable {
        Subscriber preInterceptionInformation = this;
        InterceptionResult preInterceptionResult = this.preInterceptor.map(preInterceptor -> preInterceptor.apply(preInterceptionInformation, event)).orElseGet(InterceptionResult::success);
        if (!this.checkIfCorrectlyReified(event) || !preInterceptionResult.wasSuccessful()) {
            return;
        }
        Result<?> result = this.handler.acceptEvent(event);
        InterceptionResult postInterceptionResult = this.postInterceptor.map(postInterceptor -> postInterceptor.apply(preInterceptionInformation, event, result)).orElseGet(InterceptionResult::success);
        LOGGER.info((Object)("Post interception result was successful: " + postInterceptionResult.wasSuccessful()));
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public int compareTo(Subscriber<T> other) {
        if (this.getEventType().equals(other.getEventType())) {
            return Integer.compare(this.priority, other.priority);
        }
        return 0;
    }

    public void addPreInterceptor(IPreInterceptor preInterceptor) {
        this.preInterceptor = Optional.of(preInterceptor);
    }

    public void addPostInterceptor(IPostInterceptor postInterceptor) {
        this.postInterceptor = Optional.of(postInterceptor);
    }

    public int getPriority() {
        return this.priority;
    }

    public List<Class<?>> getReifiedClasses() {
        return this.reifiedClasses;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getHandlerType() {
        return this.handlerType;
    }

    @Override
    public Optional<Class<?>> getEnclosingType() {
        return this.enclosingType;
    }

    public Class<T> getEventType() {
        return this.forEvent;
    }

    @Override
    public List<SubscriberContract> getAssociatedContracts() {
        return this.associatedContracts;
    }

    private boolean checkIfCorrectlyReified(Object event) {
        if (event instanceof ReifiedEvent) {
            if (this.getReifiedClasses() == null || this.getReifiedClasses().isEmpty()) {
                return true;
            }
            ReifiedEvent reifiedEvent = (ReifiedEvent)event;
            return this.reifiedClasses.stream().anyMatch(type -> type.isAssignableFrom(reifiedEvent.getTypeToken().getRawType()));
        }
        return true;
    }

    public static <T> Builder<T> builder(Class<T> forEvent) {
        return new Builder<T>(forEvent);
    }

    public int hashCode() {
        return Objects.hash(this.associatedContracts, this.disposed, this.enclosingType, this.forEvent, this.handler, this.handlerType, this.name, this.postInterceptor, this.preInterceptor, this.priority, this.reifiedClasses);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Subscriber other = (Subscriber)obj;
        return Objects.equals(this.associatedContracts, other.associatedContracts) && this.disposed == other.disposed && Objects.equals(this.enclosingType, other.enclosingType) && Objects.equals(this.forEvent, other.forEvent) && Objects.equals(this.handler, other.handler) && Objects.equals(this.handlerType, other.handlerType) && Objects.equals(this.name, other.name) && Objects.equals(this.postInterceptor, other.postInterceptor) && Objects.equals(this.preInterceptor, other.preInterceptor) && this.priority == other.priority && Objects.equals(this.reifiedClasses, other.reifiedClasses);
    }

    public static final class Builder<T> {
        private int priority = 0;
        private List<Class<?>> reifiedClasses;
        private String name;
        private EventHandler<? super T> handler;
        private Class<?> handlerType = EventHandler.class;
        private Optional<Class<?>> enclosingType = Optional.empty();
        private final Class<T> forEvent;
        private Optional<IPreInterceptor> preInterceptor = Optional.empty();
        private Optional<IPostInterceptor> postInterceptor = Optional.empty();
        private List<SubscriberContract> associatedContracts = Collections.emptyList();

        private Builder(Class<T> forEvent) {
            this.forEvent = forEvent;
        }

        public Builder<T> priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder<T> reifiedClasses(Class<?>[] reifiedClasses) {
            this.reifiedClasses = Arrays.asList(reifiedClasses);
            return this;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> handler(EventHandler<? super T> handler) {
            this.handler = handler;
            return this;
        }

        public Builder<T> handlerType(Class<?> handlerType) {
            this.handlerType = handlerType;
            return this;
        }

        public Builder<T> enclosingType(Class<?> enclosingType) {
            this.enclosingType = Optional.ofNullable(enclosingType);
            return this;
        }

        public Builder<T> preInterceptor(IPreInterceptor preInterceptor) {
            this.preInterceptor = Optional.ofNullable(preInterceptor);
            return this;
        }

        public Builder<T> postInterceptor(IPostInterceptor postInterceptor) {
            this.postInterceptor = Optional.ofNullable(postInterceptor);
            return this;
        }

        public Builder<T> associatedContracts(List<SubscriberContract> associatedContracts) {
            this.associatedContracts = associatedContracts;
            return this;
        }

        public Subscriber<T> build() {
            return new Subscriber(this);
        }
    }
}

