/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.eventdriver.internal.contractchecker;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.PostIntercept;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.interceptors.InterceptorInformation;
import org.palladiosimulator.analyzer.slingshot.eventdriver.internal.contractchecker.exception.NoContractFoundException;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.InterceptionResult;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;

public final class EventContractChecker {
    private static final Logger LOGGER = Logger.getLogger(EventContractChecker.class);

    public static void checkEventContract(Method method, Object target, Class<?> eventCls) throws NoContractFoundException {
        Class<?> cls = target.getClass();
        EventContractChecker.getOnEventContract(target, eventCls).findFirst().orElseThrow(() -> new NoContractFoundException(method.getName(), cls.getCanonicalName(), eventCls.getName()));
        LOGGER.debug((Object)"Contract found!");
    }

    @PostIntercept
    public InterceptionResult postEventContractChecker(InterceptorInformation information, Object event, Result<?> result) {
        return information.getAssociatedContracts().stream().flatMap(ctr -> ctr.getThen().stream()).filter(cls -> result.getResultEvents().stream().map(r -> r.getClass()).anyMatch(rcls -> rcls.isAssignableFrom((Class<?>)cls))).findAny().map(cls -> InterceptionResult.success()).orElseGet(() -> InterceptionResult.error(null));
    }

    public static Stream<OnEvent> getOnEventContract(Object target, Class<?> eventClass) {
        return Arrays.stream((OnEvent[])target.getClass().getAnnotationsByType(OnEvent.class)).filter(contract -> contract.when().isAssignableFrom(eventClass));
    }
}

