/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.monitor.calculator;

import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.core.api.SimulationScheduling;
import org.palladiosimulator.analyzer.slingshot.monitor.data.entities.ProcessingTypeListener;
import org.palladiosimulator.analyzer.slingshot.monitor.data.entities.SlingshotMeasuringValue;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.MeasurementMade;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;

public final class ProcessingTypeMeasurementSourceListener
implements IMeasurementSourceListener {
    private final ProcessingTypeListener delegate;
    private final SimulationScheduling scheduling;

    public ProcessingTypeMeasurementSourceListener(SimulationScheduling scheduling, ProcessingTypeListener delegate) {
        this.delegate = delegate;
        this.scheduling = scheduling;
    }

    public void newMeasurementAvailable(MeasuringValue newMeasurement) {
        if (!(newMeasurement instanceof SlingshotMeasuringValue)) {
            throw new IllegalArgumentException("MeasuringValue must carry a measuring point!");
        }
        SlingshotMeasuringValue measuringValue = (SlingshotMeasuringValue)newMeasurement;
        this.delegate.onMeasurementMade(new MeasurementMade(measuringValue)).getResultEvents().stream().filter(result -> result instanceof DESEvent).map(result -> (DESEvent)result).forEach(event -> this.scheduling.scheduleEvent(event));
    }

    public void preUnregister() {
        this.delegate.preUnregister();
    }
}

