/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.monitor.calculator;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.palladiosimulator.analyzer.slingshot.core.api.SimulationScheduling;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.monitor.calculator.ProcessingTypeMeasurementSourceListener;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.CalculatorRegistered;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.ProcessingTypeRevealed;
import org.palladiosimulator.analyzer.slingshot.monitor.utils.SlingshotCalculatorWrapper;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.IObservableCalculatorRegistry;

@OnEvent.OnEvents(value={@OnEvent(when=CalculatorRegistered.class, then={}), @OnEvent(when=ProcessingTypeRevealed.class, then={})})
public class DeferredCalculatorMeasurementInitializationBehavior
implements SimulationBehaviorExtension {
    private final Map<String, Map<MetricDescription, Set<Supplier<IMeasurementSourceListener>>>> sourceListener = new HashMap<String, Map<MetricDescription, Set<Supplier<IMeasurementSourceListener>>>>();
    private final IObservableCalculatorRegistry registry;
    private final SimulationScheduling scheduling;

    @Inject
    public DeferredCalculatorMeasurementInitializationBehavior(IObservableCalculatorRegistry registry, SimulationScheduling scheduling) {
        this.registry = registry;
        this.scheduling = scheduling;
    }

    @Subscribe
    public void onCalculatorRegistered(CalculatorRegistered register) {
        Calculator calculator = (Calculator)register.getEntity();
        if (this.sourceListener.containsKey(calculator.getMeasuringPoint().getStringRepresentation())) {
            Map<MetricDescription, Set<Supplier<IMeasurementSourceListener>>> callbacks = this.sourceListener.get(calculator.getMeasuringPoint().getStringRepresentation());
            LinkedList callbacksToRemove = new LinkedList();
            callbacks.keySet().stream().filter(metricDesc -> this.checkMetricDescriptionsAndInitializeSourceListeners((MetricDescription)metricDesc, calculator, callbacks)).forEach(callbacksToRemove::add);
            callbacksToRemove.forEach(callbacks::remove);
            if (callbacks.isEmpty()) {
                this.sourceListener.remove(calculator.getMeasuringPoint().getStringRepresentation());
            }
        }
    }

    @Subscribe
    public void onProcessingTypeRevealed(ProcessingTypeRevealed processingTypeRevealed) {
        Optional<Calculator> baseCalculator = this.getBaseCalculator(processingTypeRevealed.getMetricDescription(), processingTypeRevealed.getMeasuringPoint());
        if (baseCalculator.isPresent()) {
            baseCalculator.get().addObserver(SlingshotCalculatorWrapper.wrap(baseCalculator.get(), (IMeasurementSourceListener)new ProcessingTypeMeasurementSourceListener(this.scheduling, processingTypeRevealed.getMeasurementSourceListener())));
        } else {
            this.sourceListener.computeIfAbsent(processingTypeRevealed.getMeasuringPoint().getStringRepresentation(), s -> new HashMap()).computeIfAbsent(processingTypeRevealed.getMetricDescription(), d -> new HashSet()).add(() -> SlingshotCalculatorWrapper.wrap(processingTypeRevealed.getMeasuringPoint(), (IMeasurementSourceListener)new ProcessingTypeMeasurementSourceListener(this.scheduling, processingTypeRevealed.getMeasurementSourceListener())));
        }
    }

    private boolean checkMetricDescriptionsAndInitializeSourceListeners(MetricDescription metricDescription, Calculator calculator, Map<MetricDescription, Set<Supplier<IMeasurementSourceListener>>> callbacks) {
        if (this.isSameOrSubsumedMetric(metricDescription, calculator.getMetricDesciption())) {
            callbacks.get(metricDescription).stream().map(Supplier::get).forEach(arg_0 -> ((Calculator)calculator).addObserver(arg_0));
            return true;
        }
        return false;
    }

    private boolean isSameOrSubsumedMetric(MetricDescription metricDescription1, MetricDescription metricDescription2) {
        return metricDescription1.getId().equals(metricDescription2.getId()) || metricDescription1 instanceof BaseMetricDescription && MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)((BaseMetricDescription)metricDescription1), (MetricDescription)metricDescription2);
    }

    private Optional<Calculator> getBaseCalculator(MetricDescription metricDescription, MeasuringPoint mp) {
        Calculator baseCalculator = this.registry.getCalculatorByMeasuringPointAndMetricDescription(mp, metricDescription);
        if (baseCalculator == null && metricDescription instanceof BaseMetricDescription) {
            return this.registry.getCalculatorsForMeasuringPoint(mp).stream().filter(calc -> MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)((BaseMetricDescription)metricDescription), (MetricDescription)calc.getMetricDesciption())).findAny();
        }
        return Optional.ofNullable(baseCalculator);
    }
}

