/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.monitor.probes;

import java.util.List;
import java.util.function.Function;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.monitor.probes.EventBasedProbe;
import org.palladiosimulator.analyzer.slingshot.monitor.probes.EventDistinguisher;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.measurementframework.measureprovider.MeasurementListMeasureProvider;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.probeframework.measurement.ProbeMeasurement;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.Probe;

public abstract class EventBasedListProbe<V, Q extends Quantity>
extends EventBasedProbe<V, Q> {
    private final Function<DESEvent, MeasuringValue> firstvalue;
    private final Function<DESEvent, MeasuringValue> secondvalue;

    protected EventBasedListProbe(MetricDescription metricDescription) {
        this(metricDescription, EventDistinguisher.DEFAULT_DISTINGUISHER);
    }

    public EventBasedListProbe(MetricDescription metricDescription, EventDistinguisher distinguisher) {
        super(metricDescription, distinguisher);
        if (!(metricDescription instanceof MetricSetDescription)) {
            throw new IllegalArgumentException(String.format("Illegal Metric Decription for Unary Calculator. Got %s %s but require a MetricSetDescription.", metricDescription.getClass().getSimpleName(), metricDescription.getName()));
        }
        EList descriptions = ((MetricSetDescription)this.getMetricDesciption()).getSubsumedMetrics();
        if (((MetricDescription)descriptions.get(0)).equals(MetricDescriptionConstants.POINT_IN_TIME_METRIC)) {
            this.firstvalue = this::getTime;
            this.secondvalue = arg_0 -> this.lambda$1((List)descriptions, arg_0);
        } else if (((MetricDescription)descriptions.get(1)).equals(MetricDescriptionConstants.POINT_IN_TIME_METRIC)) {
            this.secondvalue = this::getTime;
            this.firstvalue = arg_0 -> this.lambda$3((List)descriptions, arg_0);
        } else {
            throw new IllegalArgumentException(String.format("Expected MetricSetDescription with at least one point in time metric, but got %s.", metricDescription.getName()));
        }
    }

    private MeasuringValue getTime(DESEvent event) {
        return new BasicMeasurement(Measure.valueOf((double)event.time(), (Unit)SI.SECOND), (BaseMetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC).getMeasuringValueForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
    }

    private MeasuringValue getValue(DESEvent event, BaseMetricDescription desc) {
        return new BasicMeasurement(this.getMeasurement(event), desc).getMeasuringValueForMetric((MetricDescription)desc);
    }

    @Override
    protected ProbeMeasurement getProbeMeasurement(DESEvent event) {
        MeasurementListMeasureProvider resultMeasurement = new MeasurementListMeasureProvider(List.of(this.firstvalue.apply(event), this.secondvalue.apply(event)));
        return new ProbeMeasurement((IMeasureProvider)resultMeasurement, (Probe)this, (RequestContext)this.getDistinguisher().apply(event));
    }

    private /* synthetic */ MeasuringValue lambda$1(List list, DESEvent e) {
        return this.getValue(e, (BaseMetricDescription)list.get(1));
    }

    private /* synthetic */ MeasuringValue lambda$3(List list, DESEvent e) {
        return this.getValue(e, (BaseMetricDescription)list.get(0));
    }
}

