/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.ui.tabs;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.slingshot.common.events.SystemEvent;
import org.palladiosimulator.analyzer.slingshot.core.Slingshot;
import org.palladiosimulator.analyzer.slingshot.core.api.SystemDriver;
import org.palladiosimulator.analyzer.slingshot.ui.events.ArchitectureModelsTabBuilderStarted;

public class SimulationArchitectureModelsTab
extends AbstractLaunchConfigurationTab {
    private static final Logger LOGGER = Logger.getLogger(SimulationArchitectureModelsTab.class);
    private static final String NAME = "Architectural Models";
    private static final String ID = "org.palladiosimulator.analyzer.slingshot.architecturemodelstab";
    private Iterator<ArchitectureModelsTabBuilderStarted.TextField> iterator;
    private final Map<ArchitectureModelsTabBuilderStarted.TextField, Text> texts = new HashMap<ArchitectureModelsTabBuilderStarted.TextField, Text>();
    private final ModifyListener modifyListener;
    private Composite container;

    public SimulationArchitectureModelsTab() {
        SystemDriver systemDriver = Slingshot.getInstance().getSystemDriver();
        ArchitectureModelsTabBuilderStarted event = new ArchitectureModelsTabBuilderStarted();
        systemDriver.postEventAndThen((SystemEvent)event, () -> {
            this.iterator = event.iterator();
        });
        this.modifyListener = modifyEvent -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        };
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.setControl((Control)this.container);
        this.container.setLayout((Layout)new GridLayout());
        this.iterator.forEachRemaining(textField -> {
            Text text = new Text(this.container, 2052);
            TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)textField.getLabel(), (String[])textField.getFileExtensions(), (Text)text, (String)textField.getPromptTitle(), (Shell)this.getShell(), (String)"");
            this.texts.put((ArchitectureModelsTabBuilderStarted.TextField)textField, text);
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.texts.forEach((textField, text) -> {
            try {
                text.setText(configuration.getAttribute(textField.getFileName(), ""));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        });
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.texts.forEach((textField, text) -> configuration.setAttribute(textField.getFileName(), text.getText()));
    }

    public String getName() {
        return NAME;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        return this.texts.entrySet().stream().filter(entry -> !((ArchitectureModelsTabBuilderStarted.TextField)entry.getKey()).isOptional()).filter(entry -> !TabHelper.validateFilenameExtension((String)((Text)entry.getValue()).getText(), (String[])((ArchitectureModelsTabBuilderStarted.TextField)entry.getKey()).getFileExtensions())).findFirst().map(entry -> {
            this.setErrorMessage(String.valueOf(((ArchitectureModelsTabBuilderStarted.TextField)entry.getKey()).getLabel()) + " is missing");
            return false;
        }).orElse(true);
    }
}

