/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.workflow.events;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.palladiosimulator.analyzer.slingshot.common.events.AbstractSystemEvent;
import org.palladiosimulator.analyzer.slingshot.workflow.events.PCMWorkflowConfiguration;

public final class WorkflowLaunchConfigurationBuilderInitialized
extends AbstractSystemEvent {
    private final ILaunchConfiguration launchConfiguration;
    private final PCMWorkflowConfiguration pcmWorkflowConfiguration;

    public WorkflowLaunchConfigurationBuilderInitialized(ILaunchConfiguration launchConfiguration, PCMWorkflowConfiguration pcmWorkflowConfiguration) {
        this.launchConfiguration = Objects.requireNonNull(launchConfiguration);
        this.pcmWorkflowConfiguration = Objects.requireNonNull(pcmWorkflowConfiguration);
    }

    public void getConfiguration(String key, String defaultStr, BiConsumer<PCMWorkflowConfiguration, Object> toLaunchConfig) {
        try {
            String conf = this.launchConfiguration.getAttribute(key, defaultStr);
            toLaunchConfig.accept(this.pcmWorkflowConfiguration, conf);
        }
        catch (CoreException coreException) {}
    }

    public Map<String, Object> forEach() {
        try {
            return this.launchConfiguration.getAttributes();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Collections.emptyMap();
        }
    }
}

