/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.workflow.jobs;

import de.uka.ipd.sdq.simucomframework.core.SimuComConfig;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.slingshot.core.Slingshot;
import org.palladiosimulator.analyzer.slingshot.core.api.SimulationDriver;
import org.palladiosimulator.analyzer.slingshot.core.extension.PCMResourceSetPartitionProvider;
import org.palladiosimulator.analyzer.slingshot.workflow.WorkflowConfigurationModule;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;

public class SimulationJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = LogManager.getLogger(SimulationJob.class);
    private MDSDBlackboard blackboard;
    private final SimulationDriver simulationDriver = Slingshot.getInstance().getSimulationDriver();
    private final PCMResourceSetPartitionProvider pcmResourceSetPartition = (PCMResourceSetPartitionProvider)Slingshot.getInstance().getInstance(PCMResourceSetPartitionProvider.class);
    private final SimuComConfig simuComConfig;

    public SimulationJob(SimuComConfig simuComConfig) {
        this.simuComConfig = simuComConfig;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        PCMResourceSetPartition partition = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        WorkflowConfigurationModule.simuComConfigProvider.set(this.simuComConfig);
        WorkflowConfigurationModule.blackboardProvider.set(this.blackboard);
        this.pcmResourceSetPartition.set(partition);
        LOGGER.debug((Object)"Current partition: ");
        partition.getResourceSet().getResources().forEach(resource -> LOGGER.debug((Object)("Resource: " + resource.getURI().path())));
        LOGGER.debug((Object)("monitor: " + monitor.getClass().getName()));
        monitor.beginTask("Start Simulation", 3);
        monitor.subTask("Initialize driver");
        this.simulationDriver.init(this.simuComConfig, monitor);
        monitor.worked(1);
        monitor.subTask("Start simulation");
        this.simulationDriver.start();
        monitor.worked(1);
        monitor.subTask("Restore");
        monitor.worked(1);
        monitor.done();
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return SimulationJob.class.getCanonicalName();
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

