/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.workflow;

import de.uka.ipd.sdq.simucomframework.core.SimuComConfig;
import de.uka.ipd.sdq.workflow.WorkflowExceptionHandler;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.logging.console.LoggerAppenderStruct;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.palladiosimulator.analyzer.slingshot.common.events.SystemEvent;
import org.palladiosimulator.analyzer.slingshot.core.Slingshot;
import org.palladiosimulator.analyzer.slingshot.core.api.SystemDriver;
import org.palladiosimulator.analyzer.slingshot.workflow.SimulationWorkflowConfiguration;
import org.palladiosimulator.analyzer.slingshot.workflow.events.PCMWorkflowConfiguration;
import org.palladiosimulator.analyzer.slingshot.workflow.events.WorkflowLaunchConfigurationBuilderInitialized;
import org.palladiosimulator.analyzer.slingshot.workflow.jobs.SimulationRootJob;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractPCMLaunchConfigurationDelegate;

public class SimulationLauncher
extends AbstractPCMLaunchConfigurationDelegate<SimulationWorkflowConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(SimulationLauncher.class);
    private final SystemDriver systemDriver = Slingshot.getInstance().getSystemDriver();

    protected IJob createWorkflowJob(SimulationWorkflowConfiguration config, ILaunch launch) throws CoreException {
        return new SimulationRootJob(config, launch);
    }

    protected SimulationWorkflowConfiguration deriveConfiguration(ILaunchConfiguration configuration, String mode) throws CoreException {
        SimuComConfig config = new SimuComConfig(configuration.getAttributes(), true);
        SimulationWorkflowConfiguration simulationWorkflowConfiguration = new SimulationWorkflowConfiguration(config);
        WorkflowLaunchConfigurationBuilderInitialized builderEvent = new WorkflowLaunchConfigurationBuilderInitialized(configuration, (PCMWorkflowConfiguration)simulationWorkflowConfiguration);
        this.systemDriver.postEvent((SystemEvent)builderEvent);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"The workfloww launch configurations are:");
            builderEvent.forEach().forEach((key, obj) -> LOGGER.debug((Object)("Key: " + key + ", Object: " + obj + "<" + obj.getClass().getName() + ">")));
        }
        return simulationWorkflowConfiguration;
    }

    protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel) throws CoreException {
        ArrayList loggerList = (ArrayList)super.setupLogging(Level.DEBUG);
        loggerList.add(this.setupLogger("org.palladiosimulator.analyzer.slingshot", logLevel, logLevel == Level.DEBUG ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        return loggerList;
    }

    protected WorkflowExceptionHandler createExceptionHandler(boolean interactive) {
        return null;
    }
}

