/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.utils;

import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ManagedPMF;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import java.text.ParseException;
import org.palladiosimulator.pcm.stoex.api.StoExParser;
import org.palladiosimulator.solver.core.utils.StringNotPMFException;

public final class ManagedPMFParser {
    private static final StoExParser STOEX_PARSER = StoExParser.createInstance();

    private ManagedPMFParser() {
    }

    public static ManagedPMF createFromString(String serializedStoEx) throws StringNotPMFException {
        Expression parsedStoEx;
        try {
            parsedStoEx = STOEX_PARSER.parse(serializedStoEx);
        }
        catch (ParseException e) {
            throw new StringNotPMFException(e.getMessage());
        }
        if (!(parsedStoEx instanceof ProbabilityFunctionLiteral)) {
            throw new StringNotPMFException();
        }
        ProbabilityFunctionLiteral pmfLiteral = (ProbabilityFunctionLiteral)parsedStoEx;
        if (!(pmfLiteral.getFunction_ProbabilityFunctionLiteral() instanceof ProbabilityMassFunction)) {
            throw new StringNotPMFException();
        }
        ProbabilityMassFunction pmf = (ProbabilityMassFunction)pmfLiteral.getFunction_ProbabilityFunctionLiteral();
        return new ManagedPMF(pmf);
    }
}

