/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.visitors;

import de.uka.ipd.sdq.stoex.Expression;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.context.aggregatedUsageContext.AggregatedCommunication;
import org.palladiosimulator.solver.context.aggregatedUsageContext.AggregatedResourceDemand;
import org.palladiosimulator.solver.context.aggregatedUsageContext.AggregatedUsageContextFactory;
import org.palladiosimulator.solver.context.aggregatedUsageContext.ServiceExecutionContext;
import org.palladiosimulator.solver.context.computed_usage.BranchProbability;
import org.palladiosimulator.solver.context.computed_usage.LoopIteration;
import org.palladiosimulator.solver.core.handler.AggregatedContextExternalCallActionHandler;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.visitors.ExpressionHelper;
import org.palladiosimulator.solver.core.visitors.SeffVisitor;

public class AggregatedContextSEFFVisitor
extends SeffVisitor {
    private double currentFrequency;
    private ServiceExecutionContext computedAggregatedUsage;
    private UsageScenario usageScenario;

    public AggregatedContextSEFFVisitor(ContextWrapper ctxWrp, double frequency, ServiceEffectSpecification seff, UsageScenario currentScenario) {
        super(ctxWrp);
        this.currentFrequency = frequency;
        this.usageScenario = currentScenario;
        if (seff instanceof ResourceDemandingSEFF) {
            ResourceDemandingSEFF rdSEFF = (ResourceDemandingSEFF)seff;
            AllocationContext allocationContext = ctxWrp.getAllCtx();
            ctxWrp.getAllCtx();
            this.computedAggregatedUsage = this.createOrReuseExecutionContext(rdSEFF, allocationContext, this.usageScenario, this.currentFrequency);
        }
    }

    @Override
    public Object caseResourceDemandingSEFF(ResourceDemandingSEFF seff) {
        this.computedAggregatedUsage.setDescribedSEFF_ServiceExecutionContext(seff);
        Object object = super.caseResourceDemandingSEFF(seff);
        return object;
    }

    @Override
    public Object caseExternalCallAction(ExternalCallAction call) {
        AggregatedContextExternalCallActionHandler extCallAH = new AggregatedContextExternalCallActionHandler(this, this.usageScenario);
        extCallAH.handle(call);
        ServiceEffectSpecification seff = extCallAH.getCalledSEFF();
        if (seff instanceof ResourceDemandingSEFF) {
            ResourceDemandingSEFF rdSEFF = (ResourceDemandingSEFF)seff;
            AllocationContext allocationContext = extCallAH.getCalledAllocationContext();
            ServiceExecutionContext calleeComputedAggregatedUsage = this.createOrReuseExecutionContext(rdSEFF, allocationContext, this.usageScenario, 0.0);
            AggregatedCommunication communication = this.createOrReuseAggregatedCommunication(this.computedAggregatedUsage, calleeComputedAggregatedUsage);
            double oldFrequency = communication.getAverageMessageFrequency();
            communication.setAverageMessageFrequency(oldFrequency + this.currentFrequency);
            CommunicationLinkResourceSpecification link = this.findCommunicationLink(this.computedAggregatedUsage, calleeComputedAggregatedUsage);
            if (link != null) {
                communication.setUsedCommunicationLinkResourceSpecification_AggregatedCommunication(link);
            }
        }
        this.doSwitch((EObject)call.getSuccessor_AbstractAction());
        return call;
    }

    private CommunicationLinkResourceSpecification findCommunicationLink(ServiceExecutionContext callerComputedAggregatedUsage, ServiceExecutionContext calleeComputedAggregatedUsage) {
        AllocationContext to = calleeComputedAggregatedUsage.getAllocationContext_ServiceExecutionContext();
        AllocationContext from = this.contextWrapper.getAllCtx();
        Allocation allocation = this.contextWrapper.getPcmInstance().getAllocation();
        if (to != null) {
            ResourceContainer toResourceContainer;
            ResourceContainer fromResourceContainer = from.getResourceContainer_AllocationContext();
            if (fromResourceContainer == (toResourceContainer = to.getResourceContainer_AllocationContext())) {
                return null;
            }
            EList linkingResourceList = this.contextWrapper.getPcmInstance().getResourceEnvironment().getLinkingResources__ResourceEnvironment();
            for (LinkingResource linkingResource : linkingResourceList) {
                if (!linkingResource.getConnectedResourceContainers_LinkingResource().contains((Object)fromResourceContainer) || !linkingResource.getConnectedResourceContainers_LinkingResource().contains((Object)toResourceContainer)) continue;
                return linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource();
            }
            throw new RuntimeException("The communication between allocation contexts " + to.getEntityName() + " and " + from.getEntityName() + " is remote, but there is no linking resource between them. Add a linking resource.");
        }
        throw new RuntimeException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ": Could not determine allocation of " + calleeComputedAggregatedUsage.getDescribedSEFF_ServiceExecutionContext().getDescribedService__SEFF().getEntityName() + " to determine communication partners.");
    }

    private boolean isOrContainsAssemblyContext(AssemblyContext currenAssemblyContext, AssemblyContext targetAssembly) {
        if (currenAssemblyContext == targetAssembly) {
            return true;
        }
        RepositoryComponent component = currenAssemblyContext.getEncapsulatedComponent__AssemblyContext();
        if (component instanceof CompositeComponent) {
            CompositeComponent composite = (CompositeComponent)component;
            for (AssemblyContext containedAssemblyContext : composite.getAssemblyContexts__ComposedStructure()) {
                boolean contained = this.isOrContainsAssemblyContext(containedAssemblyContext, targetAssembly);
                if (!contained) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object caseInternalAction(InternalAction action) {
        for (ParametricResourceDemand demand : action.getResourceDemand_Action()) {
            String specification = demand.getSpecification_ParametericResourceDemand().getSpecification();
            Expression solvedExpr = ExpressionHelper.getSolvedExpression(specification, this.contextWrapper);
            ProcessingResourceType resourceType = demand.getRequiredResource_ParametricResourceDemand();
            double meanDemand = ExpressionHelper.meanValue(solvedExpr);
            this.addToAggregatedUsage((ResourceType)resourceType, meanDemand);
        }
        Object object = super.caseInternalAction(action);
        return object;
    }

    private void addToAggregatedUsage(ResourceType resourceType, double demand) {
        double weightedDemand = demand * this.currentFrequency;
        AggregatedResourceDemand resourceDemandForType = null;
        EList existingResourceDemands = this.computedAggregatedUsage.getAggregatedResourceDemands_ServiceExecutionContext();
        for (AggregatedResourceDemand aggregatedResourceDemand : existingResourceDemands) {
            if (!aggregatedResourceDemand.getResourceType_AggregatedResourceDemand().equals(resourceType)) continue;
            resourceDemandForType = aggregatedResourceDemand;
            break;
        }
        if (resourceDemandForType == null) {
            resourceDemandForType = AggregatedUsageContextFactory.eINSTANCE.createAggregatedResourceDemand();
            resourceDemandForType.setResourceType_AggregatedResourceDemand(resourceType);
            this.computedAggregatedUsage.getAggregatedResourceDemands_ServiceExecutionContext().add((Object)resourceDemandForType);
        }
        double newAggregatedValue = resourceDemandForType.getAggregatedResourceDemand() + weightedDemand;
        resourceDemandForType.setAggregatedResourceDemand(newAggregatedValue);
    }

    @Override
    public Object caseResourceDemandingBehaviour(ResourceDemandingBehaviour behaviour) {
        double oldProbability = this.currentFrequency;
        EObject container = behaviour.eContainer();
        if (container instanceof AbstractBranchTransition) {
            AbstractBranchTransition branchTransition = (AbstractBranchTransition)container;
            double branchProb = -1.0;
            EList branchProbabilities = this.contextWrapper.getCompUsgCtx().getBranchProbabilities_ComputedUsageContext();
            for (BranchProbability branchProbability : branchProbabilities) {
                if (!branchTransition.equals(branchProbability.getBranchtransition_BranchProbability())) continue;
                branchProb = branchProbability.getProbability();
                break;
            }
            if (branchProb == -1.0) {
                throw new RuntimeException("Internal error: Found no branch transition probability for branch " + branchTransition.getEntityName() + " " + branchTransition.getId());
            }
            this.currentFrequency *= branchProb;
        } else if (container instanceof AbstractLoopAction) {
            AbstractLoopAction loop = (AbstractLoopAction)container;
            double avgLoopIterationNumber = -1.0;
            EList loopIterations = this.contextWrapper.getCompUsgCtx().getLoopiterations_ComputedUsageContext();
            for (LoopIteration loopIteration : loopIterations) {
                if (!loop.equals(loopIteration.getLoopaction_LoopIteration())) continue;
                avgLoopIterationNumber = ExpressionHelper.meanValue(ExpressionHelper.getSolvedExpression(loopIteration.getSpecification_LoopIteration().getSpecification(), this.contextWrapper));
            }
            if (avgLoopIterationNumber == -1.0) {
                throw new RuntimeException("Internal error: Found no branch transition probability for loop " + loop.getEntityName() + " " + loop.getId());
            }
            this.currentFrequency *= avgLoopIterationNumber;
        }
        Object result = super.caseResourceDemandingBehaviour(behaviour);
        this.currentFrequency = oldProbability;
        return result;
    }

    public double getCurrentFrequency() {
        return this.currentFrequency;
    }

    private ServiceExecutionContext createOrReuseExecutionContext(ResourceDemandingSEFF rdSEFF, AllocationContext allocationContext, UsageScenario usageScenario, double frequency) {
        ServiceExecutionContext computedAggregatedUsage = null;
        EList aggrUsageContext = this.contextWrapper.getPcmInstance().getComputedAggregatedUsage().getServiceExecutionContexts_ComputedAggregatedUsage();
        for (ServiceExecutionContext serviceExecutionContext : aggrUsageContext) {
            if (serviceExecutionContext.getDescribedSEFF_ServiceExecutionContext() != rdSEFF || serviceExecutionContext.getAllocationContext_ServiceExecutionContext() != allocationContext || serviceExecutionContext.getUsageScenario_ServiceExecutionContext() != usageScenario) continue;
            computedAggregatedUsage = serviceExecutionContext;
            double oldFrequency = computedAggregatedUsage.getGlobalExecutionFrequency();
            computedAggregatedUsage.setGlobalExecutionFrequency(frequency + oldFrequency);
            break;
        }
        if (computedAggregatedUsage == null) {
            computedAggregatedUsage = AggregatedUsageContextFactory.eINSTANCE.createServiceExecutionContext();
            computedAggregatedUsage.setGlobalExecutionFrequency(this.currentFrequency);
            computedAggregatedUsage.setAllocationContext_ServiceExecutionContext(allocationContext);
            computedAggregatedUsage.setUsageScenario_ServiceExecutionContext(this.usageScenario);
            computedAggregatedUsage.setDescribedSEFF_ServiceExecutionContext(rdSEFF);
            this.contextWrapper.getPcmInstance().getComputedAggregatedUsage().getServiceExecutionContexts_ComputedAggregatedUsage().add((Object)computedAggregatedUsage);
        }
        return computedAggregatedUsage;
    }

    private AggregatedCommunication createOrReuseAggregatedCommunication(ServiceExecutionContext fromService, ServiceExecutionContext toService) {
        AggregatedCommunication communication = null;
        EList communications = fromService.getSentAggregatedCommunications_ServiceExecutionContext();
        for (AggregatedCommunication aggregatedCommunication : communications) {
            if (aggregatedCommunication.getReceiver_AggregatedCommunication() != toService) continue;
            communication = aggregatedCommunication;
            break;
        }
        if (communication == null) {
            communication = AggregatedUsageContextFactory.eINSTANCE.createAggregatedCommunication();
            communication.setReceiver_AggregatedCommunication(toService);
            communications.add(communication);
        }
        return communication;
    }
}

